/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.Path;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class SimplePath
implements Comparable<SimplePath>,
Path,
Serializable {
    public static final String[] EMPTY = new String[0];
    public static final SimplePath ROOT = new SimplePath(EMPTY);
    private static final Interner<String> INTERNER = Interners.newWeakInterner();
    private static final Pattern SLOSH_SPLIT_PATTERN = Pattern.compile("[/|\\\\]");
    private static final Pattern SPLIT_PATTERN = Pattern.compile("/");
    private final String[] path;
    private String stringRep;

    public SimplePath(Path path) {
        this(path instanceof SimplePath ? path.getComponents() : SimplePath.internAll(path.getComponents()));
    }

    public SimplePath(CharSequence path) {
        this.path = SimplePath.internAll(SimplePath.split(path));
    }

    public SimplePath(CharSequence path, boolean allowSloshes) {
        this.path = SimplePath.internAll(SimplePath.split(path, allowSloshes));
    }

    public SimplePath(SimplePath aParent, String aPath) {
        this.path = SimplePath.join(aParent.path, SimplePath.internAll(SimplePath.split(aPath)));
    }

    public SimplePath(SimplePath aParent, String ... aPath) {
        this.path = SimplePath.join(aParent.path, SimplePath.internAll(aPath));
    }

    public SimplePath(SimplePath aParent, SimplePath aPath) {
        this.path = SimplePath.join(aParent.path, aPath.path);
    }

    public SimplePath(SimplePath aParent, String aPath, boolean allowSloshes) {
        this.path = SimplePath.join(aParent.path, SimplePath.internAll(SimplePath.split(aPath, allowSloshes)));
    }

    public SimplePath(String aParent, SimplePath aPath) {
        this.path = SimplePath.join(SimplePath.internAll(SimplePath.split(aParent)), aPath.path);
    }

    public SimplePath(List<String> start) {
        this(SimplePath.internAll(start.toArray(new String[start.size()])));
    }

    private SimplePath(String ... path) {
        this.path = path;
    }

    public static String join(String a, String b) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        if (a.length() == 0) {
            return b;
        }
        if (b.length() == 0) {
            return a;
        }
        if (a.endsWith("/")) {
            a = a.substring(0, a.length() - 1);
        }
        if (b.startsWith("/")) {
            b = b.substring(1);
        }
        return a + "/" + b;
    }

    public static String[] split(CharSequence aPath) {
        return SimplePath.split(aPath, false);
    }

    public static String[] split(CharSequence aPath, boolean allowSloshes) {
        if (aPath == null || aPath.length() == 0) {
            return EMPTY;
        }
        if (aPath.length() > 0 && aPath.charAt(0) == '/') {
            aPath = aPath.subSequence(1, aPath.length());
        }
        if (aPath.length() == 0) {
            return EMPTY;
        }
        Pattern splitPattern = allowSloshes ? SLOSH_SPLIT_PATTERN : SPLIT_PATTERN;
        return splitPattern.split(aPath);
    }

    public SimplePath abbreviate(int maxLength) {
        return this.abbreviateImpl(maxLength).path;
    }

    public SimplePath[] abbreviatePathComponents(int maxLength) {
        List pc = this.abbreviateImpl(maxLength).pathComponents;
        return pc.toArray(new SimplePath[pc.size()]);
    }

    @Override
    public int compareTo(SimplePath o) {
        if (o == null) {
            return -1;
        }
        String[] path = o.path;
        for (int i = 0; i < this.path.length && i < path.length; ++i) {
            String a = this.path[i];
            String b = path[i];
            int r = a.compareTo(b);
            if (r == 0) continue;
            return r;
        }
        if (this.path.length < path.length) {
            return -1;
        }
        if (path.length < this.path.length) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimplePath)) {
            return false;
        }
        SimplePath path = (SimplePath)o;
        return Arrays.equals(this.path, path.path);
    }

    public SimplePath getCommonRoot(SimplePath other) {
        int i;
        int limit = Math.min(this.path.length, other.path.length);
        for (i = 0; i < limit && this.path[i].equals(other.path[i]); ++i) {
        }
        if (i == 0) {
            return ROOT;
        }
        return new SimplePath(this.copy(i));
    }

    public String getComponent(int i) {
        return this.path[i];
    }

    @Override
    public String[] getComponents() {
        return this.copy(this.path.length);
    }

    @Override
    public String getExtension() {
        String file;
        int dot;
        String extn = null;
        if (this.path.length > 0 && (dot = (file = this.getComponent(this.path.length - 1)).lastIndexOf(".")) != -1 && dot != file.length() - 1) {
            extn = file.substring(dot + 1);
        }
        return extn;
    }

    @Override
    public String getName() {
        if (this.path.length == 0) {
            return "";
        }
        return this.path[this.path.length - 1];
    }

    public int getNumComponents() {
        return this.path.length;
    }

    @Override
    public String getParent() {
        SimplePath parent = this.getParentPath();
        return parent != null ? parent.toString() : null;
    }

    public SimplePath getParentPath() {
        if (this.path.length == 0) {
            return null;
        }
        String[] comp = new String[this.path.length - 1];
        System.arraycopy(this.path, 0, comp, 0, comp.length);
        return new SimplePath(comp);
    }

    public String getPath() {
        if (this.stringRep == null) {
            StringBuilder buf = new StringBuilder();
            String sep = "";
            for (String path : this.path) {
                buf.append(sep).append(path);
                sep = "/";
            }
            this.stringRep = buf.toString();
        }
        return this.stringRep;
    }

    public String getPath(boolean caseSensitive) {
        String normalized = caseSensitive ? this.getPath() : this.getPath().toLowerCase(Locale.US);
        return normalized;
    }

    public SimplePath[] getPathComponents() {
        SimplePath[] paths = new SimplePath[this.path.length + 1];
        for (int i = 0; i <= this.path.length; ++i) {
            paths[i] = new SimplePath(this.copy(i));
        }
        return paths;
    }

    public SimplePath getPathHead() {
        if (this.path.length == 0) {
            return this;
        }
        return new SimplePath((CharSequence)this.path[0]);
    }

    public SimplePath getStripTail(SimplePath other, boolean caseSensitive) {
        if (this.path.length < other.path.length) {
            return null;
        }
        for (int i = 0; i < other.path.length; ++i) {
            String component1 = this.path[this.path.length - i - 1];
            String component2 = other.path[other.path.length - i - 1];
            if (!(caseSensitive ? !component1.equals(component2) : !component1.equalsIgnoreCase(component2))) continue;
            return null;
        }
        return this.getSubPath(this.path.length - other.path.length);
    }

    public SimplePath getSubPath(int depth) {
        return new SimplePath(this.copy(Math.min(depth, this.path.length)));
    }

    public String getTail() {
        return this.trimFirst(1).getPath();
    }

    public SimplePath getTailPath() {
        return this.trimFirst(1);
    }

    public boolean hasPrefix(SimplePath p) {
        return this.hasPrefix(p, true);
    }

    public boolean hasPrefix(SimplePath p, boolean caseSensitive) {
        if (p == null) {
            return true;
        }
        if (p.getNumComponents() > this.getNumComponents()) {
            return false;
        }
        for (int i = 0; i < p.path.length; ++i) {
            String p1 = p.path[i];
            String p0 = this.path[i];
            if ((!caseSensitive || p1.equals(p0)) && p1.equalsIgnoreCase(p0)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (String s : this.path) {
            result += s.hashCode();
        }
        return result;
    }

    public boolean isAncestor(SimplePath descendant) {
        String[] child = descendant.path;
        String[] parent = this.path;
        if (child.length <= parent.length) {
            return false;
        }
        for (int i = 0; i < parent.length; ++i) {
            if (parent[i].equals(child[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isRoot() {
        return this.path.length == 0 || this.path.length == 1 && this.path[0].length() == 0;
    }

    public SimplePath simplify() {
        List<String> simplify = SimplePath.simplify(this.path);
        return new SimplePath(simplify.toArray(new String[simplify.size()]));
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    public SimplePath trimFirst() {
        return this.trimFirst(1);
    }

    public SimplePath trimFirst(int n) {
        if (this.path.length == 0) {
            return this;
        }
        int newLen = this.path.length - n;
        if (newLen <= 0) {
            return ROOT;
        }
        String[] p = new String[newLen];
        System.arraycopy(this.path, n, p, 0, p.length);
        return new SimplePath(p);
    }

    public SimplePath trimLast() {
        if (this.path.length == 0) {
            return this;
        }
        if (this.path.length == 1) {
            return ROOT;
        }
        String[] p = new String[this.path.length - 1];
        System.arraycopy(this.path, 0, p, 0, p.length);
        return new SimplePath(p);
    }

    private static String[] internAll(String[] components) {
        for (int i = 0; i < components.length; ++i) {
            components[i] = (String)INTERNER.intern((Object)components[i]);
        }
        return components;
    }

    private static String[] join(String[] aLeft, String[] aRight) {
        int left = aLeft.length;
        int right = aRight.length;
        String[] result = new String[left + right];
        System.arraycopy(aLeft, 0, result, 0, left);
        System.arraycopy(aRight, 0, result, left, right);
        return result;
    }

    private static List<String> simplify(String[] aPath) {
        String s0;
        ArrayList path = Lists.newArrayList((Object[])aPath);
        for (int i = 0; i < path.size(); ++i) {
            String s1 = (String)path.get(i);
            if ("..".equals(s1) && i > 0) {
                String s02 = (String)path.get(i - 1);
                if ("..".equals(s02)) continue;
                path.remove(i--);
                path.remove(i--);
                continue;
            }
            if (!".".equals(s1)) continue;
            path.remove(i--);
        }
        if (path.size() == 1 && (s0 = (String)path.get(0)).length() == 0) {
            path.remove(0);
        }
        return path;
    }

    private AbbrevResult abbreviateImpl(int maxLength) {
        String ellipses = "...";
        if (this.path.length <= 2) {
            return new AbbrevResult(this, Arrays.asList(this.getPathComponents()));
        }
        int len = this.getPath().length();
        if (len <= maxLength) {
            return new AbbrevResult(this, Arrays.asList(this.getPathComponents()));
        }
        ArrayList components = Lists.newArrayList((Object[])this.path);
        ArrayList pathComponents = Lists.newArrayList((Object[])this.getPathComponents());
        int insertEllipsesAt = components.size() / 2;
        while (len > maxLength && components.size() > 2) {
            int midPoint = components.size() / 2;
            insertEllipsesAt = Math.min(insertEllipsesAt, midPoint);
            String s = (String)components.remove(midPoint);
            pathComponents.remove(midPoint);
            len -= s.length() + 1;
        }
        components.add(insertEllipsesAt, ellipses);
        pathComponents.add(insertEllipsesAt, null);
        return new AbbrevResult(new SimplePath(components.toArray(new String[components.size()])), pathComponents);
    }

    private String[] copy(int i) {
        String[] comp = new String[i];
        System.arraycopy(this.path, 0, comp, 0, i);
        return comp;
    }

    private static class AbbrevResult {
        private SimplePath path;
        private List<SimplePath> pathComponents;

        public AbbrevResult(SimplePath path, List<SimplePath> pathComponents) {
            this.path = path;
            this.pathComponents = pathComponents;
        }
    }
}

