/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium.visualcomparison.utils;

import com.atlassian.annotations.Internal;
import com.atlassian.selenium.visualcomparison.utils.BoundingBox;
import com.atlassian.selenium.visualcomparison.utils.PageDifference;
import com.atlassian.selenium.visualcomparison.utils.PageDifferenceImages;
import com.atlassian.selenium.visualcomparison.utils.ReportRenderer;
import com.atlassian.selenium.visualcomparison.utils.ScreenResolution;
import com.atlassian.selenium.visualcomparison.utils.Screenshot;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.velocity.VelocityContext;

@Internal
public class ScreenshotDiff {
    private Screenshot oldScreenshot;
    private Screenshot newScreenshot;
    private String id;
    private ScreenResolution resolution;
    private BufferedImage diffImage;
    private List<BoundingBox> ignoreAreas;
    private Collection<PageDifference> differences;

    public ScreenshotDiff(Screenshot oldScreenshot, Screenshot newScreenshot, String id, ScreenResolution resolution, BufferedImage diffImage, ArrayList<BoundingBox> boxes, List<BoundingBox> ignoreAreas) {
        this.oldScreenshot = oldScreenshot;
        this.newScreenshot = newScreenshot;
        this.id = id;
        this.resolution = resolution;
        this.diffImage = diffImage;
        this.ignoreAreas = ignoreAreas;
        this.differences = new ArrayList<PageDifference>();
        for (BoundingBox box : boxes) {
            this.differences.add(new PageDifference(box));
        }
    }

    public Collection<PageDifference> getDifferences() {
        return this.differences;
    }

    List<BoundingBox> getDiffAreas() {
        ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
        for (PageDifference difference : this.getDifferences()) {
            boxes.add(difference.getBoundingBox());
        }
        return boxes;
    }

    public boolean hasDifferences() {
        return this.getDifferences().size() > 0;
    }

    public static String getImageOutputDir(String outputDir, String imageSubDir) {
        String imageOutputDir = outputDir + "/";
        if (imageSubDir != null && !imageSubDir.equals("")) {
            imageOutputDir = imageOutputDir + imageSubDir + "/";
        }
        return imageOutputDir;
    }

    public static String relativePath(File file, String relativeRoot) {
        String fullPath = file.getAbsolutePath();
        String relativePath = fullPath.substring(fullPath.indexOf(relativeRoot) + relativeRoot.length());
        if (relativePath.startsWith("/")) {
            relativePath = "." + relativePath;
        }
        return relativePath;
    }

    public void writeDiffReport(String outputDir, String imageSubDir) throws Exception {
        if (!this.hasDifferences()) {
            return;
        }
        String imageOutputDir = ScreenshotDiff.getImageOutputDir(outputDir, imageSubDir);
        int i = 0;
        for (PageDifference difference : this.getDifferences()) {
            BoundingBox box = difference.getBoundingBox();
            Graphics2D graphics = this.diffImage.createGraphics();
            String oldImagePath = imageOutputDir + "boxold" + i + "-" + this.id + "." + this.resolution + ".png";
            String newImagePath = imageOutputDir + "boxnew" + i + "-" + this.id + "." + this.resolution + ".png";
            String diffImagePath = imageOutputDir + "boxdiff" + i + "-" + this.id + "." + this.resolution + ".png";
            File oldImageFile = this.writeSubImage(this.oldScreenshot.getImage(), box, oldImagePath);
            File newImageFile = this.writeSubImage(this.newScreenshot.getImage(), box, newImagePath);
            File diffImageFile = this.writeSubImage(this.diffImage, box, diffImagePath);
            ++i;
            graphics.setColor(Color.BLACK);
            BasicStroke stroke = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{10.0f}, 0.0f);
            graphics.setStroke(stroke);
            graphics.drawRect(box.getMarginLeft(), box.getMarginTop(), box.getMarginWidth(this.diffImage.getWidth() - 1), box.getMarginHeight(this.diffImage.getHeight() - 1));
            difference.setImages(new PageDifferenceImages(oldImageFile, newImageFile, diffImageFile, outputDir));
        }
        if (this.ignoreAreas != null) {
            for (BoundingBox ignoreArea : this.ignoreAreas) {
                Graphics2D graphics = this.diffImage.createGraphics();
                graphics.setColor(Color.ORANGE);
                BasicStroke stroke = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{10.0f}, 0.0f);
                graphics.setStroke(stroke);
                graphics.drawRect(ignoreArea.getLeft(), ignoreArea.getTop(), ignoreArea.getWidth(), ignoreArea.getHeight());
            }
        }
        File diffImageFile = new File(imageOutputDir + "diff-" + this.id + "." + this.resolution + ".png");
        ImageIO.write((RenderedImage)this.diffImage, "png", diffImageFile);
        this.diffImage.flush();
        File oldImageFile = new File(imageOutputDir + "old-" + this.oldScreenshot.getFileName());
        ImageIO.write((RenderedImage)this.oldScreenshot.getImage(), "png", oldImageFile);
        File newImageFile = new File(imageOutputDir + this.newScreenshot.getFileName());
        ImageIO.write((RenderedImage)this.newScreenshot.getImage(), "png", newImageFile);
        VelocityContext context = ReportRenderer.createContext();
        context.put("id", (Object)this.id);
        context.put("resolution", (Object)this.resolution);
        context.put("differences", this.differences);
        context.put("oldImageFile", (Object)ScreenshotDiff.relativePath(oldImageFile, outputDir));
        context.put("newImageFile", (Object)ScreenshotDiff.relativePath(newImageFile, outputDir));
        context.put("diffImageFile", (Object)ScreenshotDiff.relativePath(diffImageFile, outputDir));
        String report = ReportRenderer.render(context, "visual-regression-report-single.vm");
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(new File(outputDir + "/report-" + this.id + "-" + this.resolution + ".html")));
        writer.append(report);
        writer.close();
    }

    private File writeSubImage(BufferedImage image, BoundingBox box, String outputPath) throws IOException {
        BufferedImage boxImage = image.getSubimage(box.getMarginLeft(), box.getMarginTop(), box.getMarginWidth(image.getWidth() - 1), box.getMarginHeight(image.getHeight() - 1));
        File outputFile = new File(outputPath);
        ImageIO.write((RenderedImage)boxImage, "png", outputFile);
        return outputFile;
    }
}

