/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium.visualcomparison.v2;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.selenium.visualcomparison.ScreenElement;
import com.atlassian.selenium.visualcomparison.VisualComparableClient;
import com.atlassian.selenium.visualcomparison.VisualComparer;
import com.atlassian.selenium.visualcomparison.utils.BoundingBox;
import com.atlassian.selenium.visualcomparison.utils.ScreenResolution;
import com.atlassian.selenium.visualcomparison.v2.BrowserEngine;
import com.atlassian.selenium.visualcomparison.v2.Comparer;
import com.atlassian.selenium.visualcomparison.v2.ComparisonSettings;
import com.atlassian.selenium.visualcomparison.v2.VisualComparisonFailedException;
import com.atlassian.selenium.visualcomparison.v2.settings.PagePart;
import com.atlassian.selenium.visualcomparison.v2.settings.Replacement;
import com.atlassian.selenium.visualcomparison.v2.settings.Resolution;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@ExperimentalApi
@Immutable
public final class DefaultComparer
implements Comparer {
    private final BrowserEngine engine;
    private final ComparisonSettings settings;

    public DefaultComparer(@Nonnull BrowserEngine engine, ComparisonSettings settings) {
        this.engine = (BrowserEngine)Preconditions.checkNotNull((Object)engine, (Object)"engine");
        this.settings = (ComparisonSettings)Preconditions.checkNotNull((Object)settings, (Object)"settings");
    }

    @Override
    public void compare(@Nonnull String id) {
        this.compare(id, ComparisonSettings.emptySettings());
    }

    @Override
    public void compare(@Nonnull String id, @Nonnull ComparisonSettings extraSettings) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkNotNull((Object)extraSettings, (Object)"settings");
        ComparisonSettings effectiveSettings = this.settings.merge(extraSettings);
        this.validateSettings(effectiveSettings);
        VisualComparer comparer = this.getComparer(effectiveSettings);
        try {
            if (!comparer.uiMatches(id, effectiveSettings.getBaselineDirectory().getAbsolutePath())) {
                String message = "Screenshots did not match the baseline in " + effectiveSettings.getBaselineDirectory().getAbsolutePath() + ".";
                if (effectiveSettings.isReportingEnabled()) {
                    message = message + " Check reports in " + effectiveSettings.getReportingDirectory().getAbsolutePath() + " for more details.";
                }
                throw new VisualComparisonFailedException(id, message);
            }
        }
        catch (Exception e) {
            if (e instanceof VisualComparisonFailedException) {
                throw (VisualComparisonFailedException)e;
            }
            throw new VisualComparisonFailedException(id, "Error when performing comparison", e);
        }
    }

    private void validateSettings(ComparisonSettings effectiveSettings) {
        Preconditions.checkState((effectiveSettings.getBaselineDirectory() != null ? 1 : 0) != 0, (Object)"Baseline directory must be provided");
        if (!effectiveSettings.getBaselineDirectory().isDirectory()) {
            Preconditions.checkState((boolean)effectiveSettings.getBaselineDirectory().mkdirs(), (Object)("Unable to create baseline directory " + effectiveSettings.getBaselineDirectory().getAbsolutePath()));
        }
        if (effectiveSettings.isReportingEnabled() && !effectiveSettings.getReportingDirectory().isDirectory()) {
            Preconditions.checkState((boolean)effectiveSettings.getReportingDirectory().mkdirs(), (Object)("Unable to create reporting directory " + effectiveSettings.getReportingDirectory().getAbsolutePath()));
        }
    }

    private VisualComparer getComparer(ComparisonSettings effectiveSettings) {
        VisualComparer comparer = new VisualComparer(new BrowserEngineComparableClient());
        comparer.setScreenResolutions(this.getResolutions(effectiveSettings));
        if (effectiveSettings.isReportingEnabled()) {
            comparer.enableReportGeneration(effectiveSettings.getReportingDirectory().getAbsolutePath());
        }
        comparer.setIgnoreSingleLineDiffs(effectiveSettings.isIgnoreSingleLineDifferences());
        comparer.setRefreshAfterResize(effectiveSettings.isRefreshAfterResize());
        comparer.setIgnoreAreas(this.getIgnoreAreas(effectiveSettings));
        comparer.setUIStringReplacements(this.getReplacements(effectiveSettings));
        comparer.setWaitforJQueryTimeout(5000L);
        return comparer;
    }

    private ScreenResolution[] getResolutions(ComparisonSettings effectiveSettings) {
        return (ScreenResolution[])Iterables.toArray((Iterable)Iterables.transform(effectiveSettings.getResolutions(), (Function)new Function<Resolution, ScreenResolution>(){

            @Nullable
            public ScreenResolution apply(Resolution input) {
                return new ScreenResolution(input.getWidth(), input.getHeight());
            }
        }), ScreenResolution.class);
    }

    private List<BoundingBox> getIgnoreAreas(ComparisonSettings effectiveSettings) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(effectiveSettings.getIgnoredParts(), (Function)new Function<PagePart, BoundingBox>(){

            @Nullable
            public BoundingBox apply(PagePart input) {
                return new BoundingBox(input.getLeft(), input.getTop(), input.getRight(), input.getBottom());
            }
        }));
    }

    private Map<String, String> getReplacements(ComparisonSettings effectiveSettings) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Replacement replacement : effectiveSettings.getReplacements()) {
            builder.put((Object)replacement.getElementId(), (Object)replacement.getHtml());
        }
        return builder.build();
    }

    private final class BrowserEngineComparableClient
    implements VisualComparableClient {
        private BrowserEngineComparableClient() {
        }

        @Override
        public void captureEntirePageScreenshot(String filePath) {
            DefaultComparer.this.engine.captureScreenshotTo(new File(filePath));
        }

        @Override
        public ScreenElement getElementAtPoint(int x, int y) {
            return DefaultComparer.this.engine.getElementAt(x, y);
        }

        @Override
        public void evaluate(String command) {
            this.execute(command, new Object[0]);
        }

        @Override
        public Object execute(String command, Object ... arguments) {
            return DefaultComparer.this.engine.executeScript(Object.class, command, arguments);
        }

        @Override
        public boolean resizeScreen(ScreenResolution resolution, boolean refreshAfterResize) {
            DefaultComparer.this.engine.resizeTo(new Resolution((int)resolution.getWidth(), (int)resolution.getHeight()));
            if (refreshAfterResize) {
                this.refreshAndWait();
            }
            return true;
        }

        @Override
        public void refreshAndWait() {
            DefaultComparer.this.engine.reloadPage();
        }

        @Override
        public boolean waitForJQuery(long waitTimeMillis) {
            Long jQueryActive = null;
            try {
                while (jQueryActive == null || jQueryActive != 0L) {
                    jQueryActive = DefaultComparer.this.engine.executeScript(Long.class, "return window.jQuery.active", new Object[0]);
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }
    }
}

