/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium.visualcomparison.v2;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.selenium.visualcomparison.v2.settings.PagePart;
import com.atlassian.selenium.visualcomparison.v2.settings.Replacement;
import com.atlassian.selenium.visualcomparison.v2.settings.Resolution;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@ExperimentalApi
public final class ComparisonSettings {
    private final Set<Resolution> resolutions;
    private final File baselineDir;
    private final Boolean reportingEnabled;
    private final File reportingDir;
    private final Boolean ignoreSingleLineDifferences;
    private final Boolean refreshAfterResize;
    private final Iterable<PagePart> ignoredParts;
    private final Iterable<Replacement> replacements;

    private ComparisonSettings() {
        this(new Builder());
    }

    private ComparisonSettings(Builder builder) {
        this.resolutions = builder.resolutions.build();
        this.baselineDir = builder.baselineDir;
        this.reportingEnabled = builder.reportingEnabled;
        this.reportingDir = builder.reportingDir;
        this.ignoreSingleLineDifferences = builder.ignoreSingleLineDifferences;
        this.refreshAfterResize = builder.refreshAfterResize;
        this.ignoredParts = builder.ignoredParts.build();
        this.replacements = builder.replacements.build();
    }

    @Nonnull
    public static ComparisonSettings emptySettings() {
        return new ComparisonSettings();
    }

    @Nonnull
    public Set<Resolution> getResolutions() {
        return this.resolutions;
    }

    @Nullable
    public File getBaselineDirectory() {
        return this.baselineDir;
    }

    public boolean isReportingEnabled() {
        return this.reportingEnabled != null && this.reportingEnabled != false;
    }

    @Nullable
    public File getReportingDirectory() {
        return this.reportingDir;
    }

    public boolean isIgnoreSingleLineDifferences() {
        return this.ignoreSingleLineDifferences != null && this.ignoreSingleLineDifferences != false;
    }

    public boolean isRefreshAfterResize() {
        return this.refreshAfterResize != null && this.refreshAfterResize != false;
    }

    @Nonnull
    public Iterable<PagePart> getIgnoredParts() {
        return this.ignoredParts;
    }

    @Nonnull
    public Iterable<Replacement> getReplacements() {
        return this.replacements;
    }

    @Nonnull
    public ComparisonSettings merge(ComparisonSettings that) {
        return new Builder(this).merge(that).build();
    }

    @Nonnull
    public ComparisonSettings withResolution(@Nonnull Resolution resolution) {
        return new Builder(this).resolution(resolution).build();
    }

    @Nonnull
    public ComparisonSettings withResolutions(@Nonnull Resolution first, Resolution ... more) {
        return new Builder(this).resolutions(first, more).build();
    }

    @Nonnull
    public ComparisonSettings withBaselineDirectory(@Nonnull File baselineDirectory) {
        return new Builder(this).baselineDirectory(baselineDirectory).build();
    }

    @Nonnull
    public ComparisonSettings withReportingEnabled(@Nonnull File value) {
        return new Builder(this).enableReporting(value).build();
    }

    @Nonnull
    public ComparisonSettings withReportingDisabled() {
        return new Builder(this).disableReporting().build();
    }

    @Nonnull
    public ComparisonSettings ignoringSingleLineDifferences(boolean value) {
        return new Builder(this).ignoreSingleLineDifferences(value).build();
    }

    @Nonnull
    public ComparisonSettings refreshingAfterResize(boolean refreshAfterResize) {
        return new Builder(this).refreshAfterResize(refreshAfterResize).build();
    }

    @Nonnull
    public ComparisonSettings ignoringPart(@Nonnull PagePart part) {
        return new Builder(this).ignorePart(part).build();
    }

    @Nonnull
    public ComparisonSettings withReplacement(@Nonnull Replacement replacement) {
        return new Builder(this).replacement(replacement).build();
    }

    private static final class Builder {
        private final ImmutableSortedSet.Builder<Resolution> resolutions = ImmutableSortedSet.naturalOrder();
        private File baselineDir;
        private Boolean reportingEnabled;
        private File reportingDir;
        private Boolean ignoreSingleLineDifferences;
        private Boolean refreshAfterResize;
        private ImmutableList.Builder<PagePart> ignoredParts = ImmutableList.builder();
        private ImmutableList.Builder<Replacement> replacements = ImmutableList.builder();

        Builder() {
        }

        Builder(@Nonnull ComparisonSettings settings) {
            this.merge(settings);
        }

        Builder merge(@Nonnull ComparisonSettings settings) {
            Preconditions.checkNotNull((Object)settings, (Object)"settings");
            this.resolutions.addAll((Iterable)settings.resolutions);
            this.baselineDir = settings.baselineDir != null ? settings.baselineDir : this.baselineDir;
            this.reportingEnabled = settings.reportingEnabled != null ? settings.reportingEnabled : this.reportingEnabled;
            this.reportingDir = settings.reportingEnabled != null ? settings.reportingDir : this.reportingDir;
            this.ignoreSingleLineDifferences = settings.ignoreSingleLineDifferences != null ? settings.ignoreSingleLineDifferences : this.ignoreSingleLineDifferences;
            this.refreshAfterResize = settings.refreshAfterResize != null ? settings.refreshAfterResize : this.refreshAfterResize;
            this.ignoredParts.addAll(settings.ignoredParts);
            this.replacements.addAll(settings.replacements);
            return this;
        }

        @Nonnull
        Builder resolution(@Nonnull Resolution resolution) {
            this.resolutions.add((Object)resolution);
            return this;
        }

        @Nonnull
        Builder resolutions(@Nonnull Resolution resolution, Resolution ... more) {
            this.resolutions.add((Object)resolution).addAll(Arrays.asList(more));
            return this;
        }

        @Nonnull
        public Builder baselineDirectory(@Nonnull File value) {
            this.baselineDir = (File)Preconditions.checkNotNull((Object)value, (Object)"baselineDirectory");
            return this;
        }

        @Nonnull
        Builder enableReporting(@Nonnull File value) {
            Preconditions.checkNotNull((Object)value, (Object)"reportingDir");
            this.reportingEnabled = true;
            this.reportingDir = value;
            return this;
        }

        @Nonnull
        Builder disableReporting() {
            this.reportingEnabled = false;
            this.reportingDir = null;
            return this;
        }

        @Nonnull
        Builder ignoreSingleLineDifferences(boolean value) {
            this.ignoreSingleLineDifferences = value;
            return this;
        }

        @Nonnull
        Builder refreshAfterResize(boolean value) {
            this.refreshAfterResize = value;
            return this;
        }

        @Nonnull
        Builder ignorePart(@Nonnull PagePart part) {
            this.ignoredParts.add((Object)part);
            return this;
        }

        @Nonnull
        Builder ignoreParts(@Nonnull PagePart first, PagePart ... more) {
            this.ignoredParts.add((Object)first).addAll(Arrays.asList(more));
            return this;
        }

        @Nonnull
        Builder replacement(@Nonnull Replacement replacement) {
            this.replacements.add((Object)replacement);
            return this;
        }

        @Nonnull
        Builder replacements(@Nonnull Replacement first, Replacement ... more) {
            this.replacements.add((Object)first).addAll(Arrays.asList(more));
            return this;
        }

        public ComparisonSettings build() {
            return new ComparisonSettings(this);
        }
    }
}

