/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium.visualcomparison;

import com.atlassian.annotations.Internal;
import com.atlassian.selenium.visualcomparison.ScreenElement;
import com.atlassian.selenium.visualcomparison.VisualComparableClient;
import com.atlassian.selenium.visualcomparison.utils.BoundingBox;
import com.atlassian.selenium.visualcomparison.utils.PageDifference;
import com.atlassian.selenium.visualcomparison.utils.PageElementInfo;
import com.atlassian.selenium.visualcomparison.utils.ScreenResolution;
import com.atlassian.selenium.visualcomparison.utils.Screenshot;
import com.atlassian.selenium.visualcomparison.utils.ScreenshotDiff;
import java.awt.Point;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import junit.framework.Assert;

@Internal
public class VisualComparer {
    private ScreenResolution[] resolutions = new ScreenResolution[]{new ScreenResolution(1280, 1024)};
    private VisualComparableClient client;
    private boolean refreshAfterResize = false;
    private boolean reportingEnabled = false;
    private String reportOutputPath;
    private String imageSubDirName = "report_images";
    private String tempPath = System.getProperty("java.io.tmpdir");
    private Map<String, String> uiStringReplacements = null;
    private long waitforJQueryTimeout = 0L;
    private List<BoundingBox> ignoreAreas = null;
    private boolean ignoreSingleLineDiffs = false;

    public long getWaitforJQueryTimeout() {
        return this.waitforJQueryTimeout;
    }

    public void setWaitforJQueryTimeout(long waitforJQueryTimeout) {
        this.waitforJQueryTimeout = waitforJQueryTimeout;
    }

    public VisualComparer(VisualComparableClient client) {
        this.client = client;
    }

    public void setScreenResolutions(ScreenResolution[] resolutions) {
        this.resolutions = resolutions;
    }

    public ScreenResolution[] getScreenResolutions() {
        return this.resolutions;
    }

    public void setRefreshAfterResize(boolean refreshAfterResize) {
        this.refreshAfterResize = refreshAfterResize;
    }

    public boolean getRefreshAfterResize() {
        return this.refreshAfterResize;
    }

    public void setUIStringReplacements(Map<String, String> uiStringReplacements) {
        this.uiStringReplacements = uiStringReplacements;
    }

    public Map<String, String> getUIStringReplacements() {
        return this.uiStringReplacements;
    }

    public void enableReportGeneration(String reportOutputPath) {
        this.reportingEnabled = true;
        this.reportOutputPath = reportOutputPath;
        File file = new File(reportOutputPath + "/" + this.imageSubDirName);
        file.mkdirs();
    }

    public void disableReportGeneration() {
        this.reportingEnabled = false;
    }

    public void setTempPath(String tempPath) {
        File file = new File(tempPath);
        file.mkdirs();
        this.tempPath = tempPath;
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public List<BoundingBox> getIgnoreAreas() {
        return this.ignoreAreas;
    }

    public boolean getIgnoreSingleLineDiffs() {
        return this.ignoreSingleLineDiffs;
    }

    public void setIgnoreSingleLineDiffs(boolean ignoreSingleLineDiffs) {
        this.ignoreSingleLineDiffs = ignoreSingleLineDiffs;
    }

    public void setIgnoreAreas(List<BoundingBox> ignoreAreas) {
        this.ignoreAreas = ignoreAreas;
    }

    public void assertUIMatches(String id, String baselineImagePath) {
        try {
            Assert.assertTrue((String)"Screenshots were not equal", (boolean)this.uiMatches(id, baselineImagePath));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean uiMatches(String id, String baselineImagePath) throws Exception {
        ArrayList<Screenshot> currentScreenshots = this.takeScreenshots(id);
        ArrayList<Screenshot> baselineScreenshots = this.loadBaselineScreenshots(id, baselineImagePath);
        return this.compareScreenshots(baselineScreenshots, currentScreenshots);
    }

    public ArrayList<Screenshot> takeScreenshots(String id) throws IOException {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        for (ScreenResolution res : this.resolutions) {
            this.client.resizeScreen(res, this.refreshAfterResize);
            if (this.waitforJQueryTimeout > 0L && !this.client.waitForJQuery(this.waitforJQueryTimeout)) {
                Assert.fail((String)"Timed out while waiting for jQuery to complete");
            }
            if (this.uiStringReplacements != null) {
                for (String key : this.uiStringReplacements.keySet()) {
                    this.replaceUIHtml(key, this.uiStringReplacements.get(key));
                }
            }
            screenshots.add(new Screenshot(this.client, id, this.tempPath, res));
        }
        Collections.sort(screenshots);
        return screenshots;
    }

    public ArrayList<Screenshot> loadBaselineScreenshots(final String id, String baselineImagePath) throws IOException {
        File screenshotDir = new File(baselineImagePath);
        File[] screenshotFiles = screenshotDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(id);
            }
        });
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        for (File screenshotFile : screenshotFiles) {
            screenshots.add(new Screenshot(screenshotFile));
        }
        Collections.sort(screenshots);
        return screenshots;
    }

    protected void replaceUIHtml(String id, String newContent) {
        String script = "var content, el = window.document.getElementById('" + id + "');" + "if (el) { content = el.innerHTML; el.innerHTML = \"" + newContent + "\"; } content;";
        Object result = this.client.execute(script, new Object[0]);
        String value = String.valueOf(result);
    }

    public boolean compareScreenshots(ArrayList<Screenshot> oldScreenshots, ArrayList<Screenshot> newScreenshots) throws Exception {
        if (oldScreenshots.size() != newScreenshots.size()) {
            if (oldScreenshots.size() == 0) {
                if (this.reportingEnabled) {
                    String imageOutputDir = ScreenshotDiff.getImageOutputDir(this.reportOutputPath, this.imageSubDirName);
                    for (Screenshot newScreenshot : newScreenshots) {
                        ImageIO.write((RenderedImage)newScreenshot.getImage(), "png", new File(imageOutputDir + newScreenshot.getFileName()));
                    }
                }
                throw new IllegalArgumentException("There were new screenshots, but no baseline images. Is this a new test? If reporting is enabled, the new screenshots will be output in the report.");
            }
            throw new IllegalArgumentException("Incorrect number of images. There were " + oldScreenshots.size() + " baseline images," + " but only " + newScreenshots.size() + " new images.");
        }
        boolean matches = true;
        for (int i = 0; i < oldScreenshots.size(); ++i) {
            ScreenshotDiff diff = this.getScreenshotDiff(oldScreenshots.get(i), newScreenshots.get(i));
            for (PageDifference difference : diff.getDifferences()) {
                BoundingBox box = difference.getBoundingBox();
                int x = new Double(Math.floor(box.getLeft() + box.getWidth() / 2)).intValue();
                int y = new Double(Math.floor(box.getTop() + box.getHeight() / 2)).intValue();
                ScreenElement thing = this.client.getElementAtPoint(x, y);
                PageElementInfo info = new PageElementInfo();
                info.htmlContent = thing.getHtml();
                info.position = new Point(x, y);
                difference.addPageElement(info);
            }
            if (this.reportingEnabled) {
                diff.writeDiffReport(this.reportOutputPath, this.imageSubDirName);
            }
            matches = !diff.hasDifferences() && matches;
        }
        return matches;
    }

    public ScreenshotDiff getScreenshotDiff(Screenshot oldScreenshot, Screenshot newScreenshot) throws Exception {
        return oldScreenshot.getDiff(newScreenshot, this.ignoreAreas, this.ignoreSingleLineDiffs);
    }
}

