/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query.util;

import com.atlassian.pageobjects.elements.query.util.Backoff;

public class LinearBackoff
implements Backoff {
    private long interval;

    public LinearBackoff(long interval) {
        this.interval = interval;
    }

    @Override
    public void yield() throws InterruptedException {
        if (this.interval > 0L) {
            Thread.sleep(this.interval);
        }
    }

    @Override
    public void yield(long bound) throws InterruptedException {
        if (this.interval > 0L) {
            Thread.sleep(Math.min(bound, this.interval));
        }
    }

    @Override
    public void resetBackoff() {
    }
}

