/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.TimedElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.query.webdriver.WebDriverQueryFactory;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;

public class WebDriverTimedElement
implements TimedElement {
    @Inject
    PageBinder pageBinder;
    private WebDriverQueryFactory queryFactory;
    private final WebDriverLocatable locatable;
    private final TimeoutType defaultTimeout;

    public WebDriverTimedElement(WebDriverLocatable locatable, TimeoutType defaultTimeout) {
        this.locatable = Objects.requireNonNull(locatable, "locatable can't be null");
        this.defaultTimeout = Objects.requireNonNull(defaultTimeout, "defaultTimeout can't be null");
    }

    @Init
    public void initialize() {
        this.queryFactory = (WebDriverQueryFactory)this.pageBinder.bind(WebDriverQueryFactory.class, new Object[]{this.locatable});
    }

    @Override
    public TimedCondition isPresent() {
        return this.queryFactory.isPresent(this.defaultTimeout);
    }

    @Override
    public TimedCondition isVisible() {
        return this.queryFactory.isVisible(this.defaultTimeout);
    }

    @Override
    public TimedCondition isEnabled() {
        return this.queryFactory.isEnabled(this.defaultTimeout);
    }

    @Override
    public TimedCondition isSelected() {
        return this.queryFactory.isSelected(this.defaultTimeout);
    }

    @Override
    @Nonnull
    public TimedQuery<String> getId() {
        return this.queryFactory.getAttribute("id");
    }

    @Override
    @Nonnull
    public TimedQuery<Set<String>> getCssClasses() {
        return this.queryFactory.getCssClasses(this.defaultTimeout);
    }

    @Override
    public TimedCondition hasClass(String className) {
        return this.queryFactory.hasClass(className, this.defaultTimeout);
    }

    @Override
    public TimedQuery<String> getAttribute(String name) {
        return this.queryFactory.getAttribute(name, this.defaultTimeout);
    }

    @Override
    public TimedCondition hasAttribute(String name, String value) {
        return this.queryFactory.hasAttribute(name, value, this.defaultTimeout);
    }

    @Override
    public TimedQuery<String> getText() {
        return this.queryFactory.getText(this.defaultTimeout);
    }

    @Override
    public TimedCondition hasText(String text) {
        return this.queryFactory.hasText(text, this.defaultTimeout);
    }

    @Override
    public TimedQuery<String> getTagName() {
        return this.queryFactory.getTagName(this.defaultTimeout);
    }

    @Override
    public TimedQuery<String> getValue() {
        return this.queryFactory.getValue(this.defaultTimeout);
    }

    @Override
    public TimedCondition hasValue(String value) {
        return this.queryFactory.hasValue(value, this.defaultTimeout);
    }

    @Override
    public TimedQuery<Point> getLocation() {
        return this.queryFactory.getLocation(this.defaultTimeout);
    }

    @Override
    public TimedQuery<Dimension> getSize() {
        return this.queryFactory.getSize(this.defaultTimeout);
    }
}

