/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.testing;

import com.atlassian.annotations.PublicApi;
import com.atlassian.pageobjects.elements.CheckboxElement;
import com.atlassian.pageobjects.elements.PageElement;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

@PublicApi
public final class PageElementMatchers {
    private PageElementMatchers() {
        throw new AssertionError((Object)("Do not instantiate " + PageElementMatchers.class.getName()));
    }

    @Nonnull
    public static <PE extends PageElement, PEE extends PE> Matcher<PEE> asMatcherOf(@Nonnull Class<PEE> targetType, @Nonnull Matcher<PE> original) {
        Objects.requireNonNull(targetType, "targetType");
        Objects.requireNonNull(original, "original");
        return original;
    }

    @Nonnull
    public static Matcher<CheckboxElement> isChecked() {
        return new FeatureMatcher<CheckboxElement, Boolean>(Matchers.is((Object)true), "is checked", "is checked"){

            protected Boolean featureValueOf(CheckboxElement checkbox) {
                return checkbox.isChecked();
            }
        };
    }

    @Nonnull
    public static Matcher<PageElement> withAttribute(@Nonnull String name, @Nullable String expectedValue) {
        return PageElementMatchers.withAttributeThat(name, (Matcher<String>)Matchers.is((Object)expectedValue));
    }

    @Nonnull
    public static Matcher<PageElement> withAttributeThat(final @Nonnull String name, @Nonnull Matcher<String> valueMatcher) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(valueMatcher, "valueMatcher");
        String featureDescription = String.format("attribute '%s'", name);
        return new FeatureMatcher<PageElement, String>(valueMatcher, featureDescription, featureDescription){

            protected String featureValueOf(PageElement actual) {
                return actual.getAttribute(name);
            }
        };
    }

    @Nonnull
    public static Matcher<PageElement> withClass(@Nonnull String expectedClass) {
        return PageElementMatchers.withClassThat((Matcher<String>)Matchers.is((Object)expectedClass));
    }

    @Nonnull
    public static Matcher<PageElement> withClassThat(@Nonnull Matcher<String> classMatcher) {
        Objects.requireNonNull(classMatcher, "classMatcher");
        return new FeatureMatcher<PageElement, Set<String>>(Matchers.hasItem(classMatcher), "CSS class", "CSS class"){

            protected Set<String> featureValueOf(PageElement actual) {
                return actual.getCssClasses();
            }
        };
    }

    @Nonnull
    public static Matcher<PageElement> withDataAttribute(@Nonnull String name, @Nullable String expectedValue) {
        return PageElementMatchers.withDataAttributeThat(name, (Matcher<String>)Matchers.is((Object)expectedValue));
    }

    @Nonnull
    public static Matcher<PageElement> withDataAttributeThat(@Nonnull String name, @Nonnull Matcher<String> valueMatcher) {
        Objects.requireNonNull(name, "name");
        return PageElementMatchers.withAttributeThat("data-" + name, valueMatcher);
    }

    @Nonnull
    public static Matcher<PageElement> withId(@Nullable String expectedId) {
        return PageElementMatchers.withIdThat((Matcher<String>)Matchers.is((Object)expectedId));
    }

    @Nonnull
    public static Matcher<PageElement> withIdThat(@Nonnull Matcher<String> idMatcher) {
        return PageElementMatchers.withAttributeThat("id", idMatcher);
    }

    @Nonnull
    public static Matcher<PageElement> withText(@Nullable String expectedText) {
        return PageElementMatchers.withTextThat((Matcher<String>)Matchers.is((Object)expectedText));
    }

    @Nonnull
    public static Matcher<PageElement> withTextThat(@Nonnull Matcher<String> textMatcher) {
        Objects.requireNonNull(textMatcher, "textMatcher");
        return new FeatureMatcher<PageElement, String>(textMatcher, "text", "text"){

            protected String featureValueOf(PageElement actual) {
                return actual.getText();
            }
        };
    }
}

