/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFormJavascript;
import com.atlassian.pageobjects.elements.PageElementJavascript;
import com.atlassian.pageobjects.elements.PageElementMouseJavascript;
import com.atlassian.pageobjects.elements.WebDriverElement;
import com.atlassian.pageobjects.elements.WebDriverElementMappings;
import com.atlassian.pageobjects.elements.WebDriverLocators;
import com.atlassian.pageobjects.elements.query.AbstractTimedQuery;
import com.atlassian.pageobjects.elements.query.ExpirationHandler;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.utils.JavaScriptUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

final class WebDriverElementJavascript
implements PageElementJavascript {
    private static final Iterable<String> SIMPLE_JS_RESULT_TYPES = ImmutableSet.of((Object)Boolean.class.getName(), (Object)String.class.getName(), (Object)Long.class.getName(), (Object)List.class.getName());
    private final WebDriver driver;
    private final PageBinder pageBinder;
    private final WebDriverElement element;
    private final JSMouse jsMouse = new JSMouse();
    private final JSForm jsForm = new JSForm();

    WebDriverElementJavascript(WebDriverElement element) {
        this.element = Objects.requireNonNull(element, "element");
        this.driver = element.driver;
        this.pageBinder = element.pageBinder;
    }

    @Override
    public PageElementMouseJavascript mouse() {
        return this.jsMouse;
    }

    @Override
    public PageElementFormJavascript form() {
        return this.jsForm;
    }

    @Override
    public Object execute(String script, Object ... arguments) {
        Objects.requireNonNull(script, "script");
        return this.convertResult(this.getExecutor().executeScript(script, this.convertArguments(arguments)));
    }

    @Override
    public <T> T execute(Class<T> resultType, String script, Object ... arguments) {
        Objects.requireNonNull(script, "script");
        this.validateResultType(resultType);
        return this.executeConverted(resultType, script, arguments);
    }

    private <T> T executeConverted(Class<T> resultType, String script, Object[] arguments) {
        return this.convertResult(this.getExecutor().executeScript(script, this.convertArguments(arguments)), resultType);
    }

    @Override
    public <T> TimedQuery<T> executeTimed(final Class<T> resultType, final String script, final Object ... arguments) {
        Objects.requireNonNull(script, "script");
        this.validateSimpleResultType(resultType);
        return new AbstractTimedQuery<T>(this.element.timed().isPresent(), ExpirationHandler.RETURN_CURRENT){

            @Override
            protected boolean shouldReturn(T currentEval) {
                return true;
            }

            @Override
            protected T currentValue() {
                return WebDriverElementJavascript.this.executeConverted(resultType, script, arguments);
            }
        };
    }

    @Override
    public <T> T executeAsync(Class<T> resultType, String script, Object ... arguments) {
        Objects.requireNonNull(script, "script");
        this.validateResultType(resultType);
        return this.executeAsyncConverted(resultType, script, arguments);
    }

    @Override
    public Object executeAsync(String script, Object ... arguments) {
        Objects.requireNonNull(script, "script");
        return this.convertResult(this.getExecutor().executeAsyncScript(script, this.convertArguments(arguments)));
    }

    private <T> T executeAsyncConverted(Class<T> resultType, String script, Object[] arguments) {
        return this.convertResult(this.getExecutor().executeAsyncScript(script, this.convertArguments(arguments)), resultType);
    }

    private Object[] convertArguments(Object[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof PageElement)) continue;
            arguments[i] = WebDriverElement.getWebElement((PageElement)arguments[i]);
        }
        return ArrayUtils.insert((int)0, (Object[])arguments, (Object[])new Object[]{this.element.waitForWebElement()});
    }

    private Object convertResult(Object result) {
        if (result instanceof WebElement) {
            WebElement webElement = (WebElement)result;
            if (this.element.getAttribute("id") != null && this.element.getAttribute("id").equals(webElement.getAttribute("id"))) {
                return this.element;
            }
            return this.pageBinder.bind(WebDriverElement.class, new Object[]{WebDriverLocators.staticElement(webElement), this.element.defaultTimeout});
        }
        return result;
    }

    private <T> T convertResult(Object result, Class<T> expected) {
        if (result instanceof WebElement) {
            if (!PageElement.class.isAssignableFrom(expected)) {
                throw new ClassCastException("Expected instance of PageElement, was: " + expected);
            }
            WebElement webElement = (WebElement)result;
            if (this.element.getAttribute("id") != null && this.element.getAttribute("id").equals(webElement.getAttribute("id"))) {
                return expected.cast(this.element);
            }
            Object stupidWorkaroundsForStupidGenericsProblemsHaaaaaateIt = this.pageBinder.bind(WebDriverElementMappings.findMapping(expected), new Object[]{WebDriverLocators.staticElement(webElement), this.element.defaultTimeout});
            return expected.cast(stupidWorkaroundsForStupidGenericsProblemsHaaaaaateIt);
        }
        return expected.cast(result);
    }

    private JavascriptExecutor getExecutor() {
        Preconditions.checkState((boolean)(this.driver instanceof JavascriptExecutor), (Object)(this.driver + " does not support Javascript"));
        return (JavascriptExecutor)this.driver;
    }

    private <T> void validateSimpleResultType(Class<T> resultType) {
        Objects.requireNonNull(resultType, "resultType");
        if (!Iterables.contains(SIMPLE_JS_RESULT_TYPES, (Object)resultType.getName())) {
            throw new IllegalArgumentException("Class '" + resultType.getName() + "' is not a simple JS return type");
        }
    }

    private <T> void validateResultType(Class<T> resultType) {
        if (Iterables.contains(SIMPLE_JS_RESULT_TYPES, (Object)resultType.getName())) {
            return;
        }
        if (PageElement.class.isAssignableFrom(resultType)) {
            return;
        }
        throw new IllegalArgumentException("Class '" + resultType.getName() + "' is not a supported JS return type");
    }

    private PageElementJavascript dispatch(String eventType) {
        JavaScriptUtils.dispatchEvent((String)eventType, (WebElement)this.element.waitForWebElement(), (WebDriver)this.driver);
        return this;
    }

    private class JSForm
    implements PageElementFormJavascript {
        private JSForm() {
        }

        @Override
        public PageElementJavascript select() {
            return WebDriverElementJavascript.this.dispatch("select");
        }

        @Override
        public PageElementJavascript change() {
            return WebDriverElementJavascript.this.dispatch("change");
        }

        @Override
        public PageElementJavascript submit() {
            return WebDriverElementJavascript.this.dispatch("submit");
        }

        @Override
        public PageElementJavascript focus() {
            return WebDriverElementJavascript.this.dispatch("focus");
        }

        @Override
        public PageElementJavascript blur() {
            return WebDriverElementJavascript.this.dispatch("blur");
        }
    }

    private class JSMouse
    implements PageElementMouseJavascript {
        private JSMouse() {
        }

        @Override
        public PageElementJavascript click() {
            return WebDriverElementJavascript.this.dispatch("click");
        }

        @Override
        public PageElementJavascript doubleClick() {
            return WebDriverElementJavascript.this.dispatch("dblclick");
        }

        @Override
        public PageElementJavascript mouseup() {
            return WebDriverElementJavascript.this.dispatch("mouseup");
        }

        @Override
        public PageElementJavascript mousedown() {
            return WebDriverElementJavascript.this.dispatch("mousedown");
        }

        @Override
        public PageElementJavascript mouseover() {
            return WebDriverElementJavascript.this.dispatch("mouseover");
        }

        @Override
        public PageElementJavascript mousemove() {
            return WebDriverElementJavascript.this.dispatch("mousemove");
        }

        @Override
        public PageElementJavascript mouseout() {
            return WebDriverElementJavascript.this.dispatch("mouseout");
        }
    }
}

