/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.components.aui;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.components.ActivatedComponent;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class AuiInlineDialog
implements ActivatedComponent<AuiInlineDialog> {
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected PageElementFinder elementFinder;
    private final By triggerLocator;
    private final String identifier;
    private PageElement triggerElement;
    private PageElement viewElement;

    public AuiInlineDialog(By triggerLocator, String identifier) {
        this.triggerLocator = triggerLocator;
        this.identifier = identifier;
    }

    @Init
    public void initialize() {
        this.triggerElement = this.elementFinder.find(this.triggerLocator);
        this.viewElement = this.elementFinder.find(By.id((String)("inline-dialog-" + this.identifier)));
    }

    @Override
    public PageElement getTrigger() {
        return this.triggerElement;
    }

    @Override
    public PageElement getView() {
        return this.viewElement;
    }

    @Override
    public AuiInlineDialog open() {
        this.triggerElement.click();
        Poller.waitUntilTrue(this.viewElement.timed().isVisible());
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.viewElement.isPresent() && this.viewElement.isVisible();
    }
}

