/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.util;

import java.util.concurrent.TimeUnit;

public final class Timeout {
    private Timeout() {
        throw new AssertionError((Object)"Don't hack with me");
    }

    public static TimeoutBuilder of(long count) {
        return new TimeoutBuilder(count);
    }

    public static WaitTimeBuilder waitFor(long count) {
        return new WaitTimeBuilder(count);
    }

    public static final class WaitTimeBuilder {
        private final TimeoutBuilder builder;

        WaitTimeBuilder(long waitTime) {
            this.builder = new TimeoutBuilder(waitTime);
        }

        public void milliseconds() {
            this.waitFor(this.builder.milliseconds());
        }

        public void seconds() {
            this.waitFor(this.builder.seconds());
        }

        private void waitFor(long millis) {
            try {
                TimeUnit.MILLISECONDS.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class TimeoutBuilder {
        private final long count;

        TimeoutBuilder(long count) {
            assert (count >= 0L);
            this.count = count;
        }

        public long milliseconds() {
            return this.count;
        }

        public long seconds() {
            return TimeUnit.SECONDS.toMillis(this.count);
        }
    }
}

