/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query;

import com.atlassian.pageobjects.elements.query.AbstractPollingQuery;
import com.atlassian.pageobjects.elements.query.ExpirationHandler;
import com.atlassian.pageobjects.elements.query.PollingQuery;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.query.util.Clock;
import com.atlassian.pageobjects.elements.query.util.ClockAware;
import com.atlassian.pageobjects.elements.query.util.Clocks;
import com.atlassian.pageobjects.elements.query.util.SystemClock;
import com.atlassian.pageobjects.elements.util.StringConcat;
import com.atlassian.pageobjects.elements.util.Timeout;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractTimedQuery<T>
extends AbstractPollingQuery
implements TimedQuery<T>,
ClockAware {
    private final Clock clock;
    private final ExpirationHandler expirationHandler;
    private boolean lastRun = false;

    protected AbstractTimedQuery(Clock clock, long defTimeout, long interval, ExpirationHandler expirationHandler) {
        super(interval, defTimeout);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock, (Object)"clock");
        this.expirationHandler = (ExpirationHandler)Preconditions.checkNotNull((Object)expirationHandler, (Object)"expirationHandler");
    }

    protected AbstractTimedQuery(long defTimeout, long interval, ExpirationHandler expirationHandler) {
        this(SystemClock.INSTANCE, defTimeout, interval, expirationHandler);
    }

    protected AbstractTimedQuery(PollingQuery other, ExpirationHandler expirationHandler) {
        this(Clocks.getClock(other), other.defaultTimeout(), ((PollingQuery)Preconditions.checkNotNull((Object)other, (Object)"other")).interval(), expirationHandler);
    }

    @Override
    public final T by(long timeout) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        this.resetLastRun();
        long start = this.clock.currentTime();
        long deadline = start + timeout;
        while (this.withinTimeout(deadline)) {
            T current = this.currentValue();
            if (this.shouldReturn(current)) {
                return current;
            }
            if (this.isLastRun()) {
                return this.expired(current, timeout);
            }
            Timeout.waitFor(this.sleepTime(deadline)).milliseconds();
        }
        return this.expired(this.currentValue(), timeout);
    }

    @Override
    public final T by(long timeout, TimeUnit unit) {
        return this.by(TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    @Override
    public T byDefaultTimeout() {
        return this.by(this.defaultTimeout);
    }

    @Override
    public final T now() {
        T val = this.currentValue();
        if (this.shouldReturn(val)) {
            return val;
        }
        return this.expired(val, 0L);
    }

    public final ExpirationHandler expirationHandler() {
        return this.expirationHandler;
    }

    protected abstract boolean shouldReturn(T var1);

    protected abstract T currentValue();

    private T expired(T currentVal, long timeout) {
        return this.expirationHandler.expired(this, currentVal, timeout);
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    private boolean withinTimeout(long deadline) {
        return this.clock.currentTime() <= deadline;
    }

    private long sleepTime(long deadline) {
        long now = this.clock.currentTime();
        if (now + this.interval < deadline) {
            return this.interval;
        }
        long toEvalOneMoreTime = deadline - now - 2L;
        this.setLastRun();
        return toEvalOneMoreTime > 0L ? toEvalOneMoreTime : 1L;
    }

    private void setLastRun() {
        this.lastRun = true;
    }

    protected void resetLastRun() {
        this.lastRun = false;
    }

    private boolean isLastRun() {
        return this.lastRun;
    }

    public String toString() {
        return StringConcat.asString(this.getClass().getName(), "[interval=", this.interval, ",defaultTimeout=", this.defaultTimeout, "]");
    }
}

