/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.pageobjects.elements.Option;
import com.atlassian.pageobjects.elements.Options;
import com.atlassian.pageobjects.elements.SelectElement;
import com.atlassian.pageobjects.elements.WebDriverElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class WebDriverSelectElement
extends WebDriverElement
implements SelectElement {
    public WebDriverSelectElement(By locator) {
        super(locator);
    }

    public WebDriverSelectElement(By locator, TimeoutType defaultTimeout) {
        super(locator, defaultTimeout);
    }

    public WebDriverSelectElement(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    public WebDriverSelectElement(By locator, WebDriverLocatable parent) {
        super(locator, parent);
    }

    public WebDriverSelectElement(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        super(locator, parent, timeoutType);
    }

    private Option buildOption(WebElement option) {
        return Options.full(option.getAttribute("id"), option.getAttribute("value"), option.getText());
    }

    @Override
    public List<Option> getAllOptions() {
        ArrayList<Option> optionList = new ArrayList<Option>();
        for (WebElement option : new Select(this.waitForWebElement()).getOptions()) {
            optionList.add(this.buildOption(option));
        }
        return optionList;
    }

    @Override
    public Option getSelected() {
        return this.buildOption(new Select(this.waitForWebElement()).getFirstSelectedOption());
    }

    @Override
    public SelectElement select(Option option) {
        for (WebElement currentOption : new Select(this.waitForWebElement()).getOptions()) {
            if (!option.equals(this.buildOption(currentOption))) continue;
            if (currentOption.isSelected()) break;
            currentOption.click();
            break;
        }
        return this;
    }
}

