/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.AbstractTimedQuery;
import com.atlassian.pageobjects.elements.query.ExpirationHandler;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.util.StringConcat;
import com.atlassian.webdriver.utils.Check;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebDriverLocators {
    public static WebDriverLocatable root() {
        return new WebDriverRootLocator();
    }

    public static WebDriverLocatable single(By locator) {
        return new WebDriverSingleLocator(locator, WebDriverLocators.root());
    }

    public static WebDriverLocatable nested(By locator, WebDriverLocatable parent) {
        return new WebDriverSingleLocator(locator, parent);
    }

    public static WebDriverLocatable list(WebElement element, By locator, int locatorIndex, WebDriverLocatable parent) {
        return new WebDriverListLocator(element, locator, locatorIndex, parent);
    }

    public static WebDriverLocatable staticElement(WebElement element) {
        return new WebDriverStaticLocator(element);
    }

    public static boolean isStale(WebElement webElement) {
        try {
            webElement.getTagName();
            return false;
        }
        catch (StaleElementReferenceException ignored) {
            return true;
        }
    }

    private static Poller.WaitTimeout withinTimeout(WebDriverLocatable.LocateTimeout timeout) {
        return timeout.timeout() > 0L ? Poller.by(timeout.timeout()) : Poller.now();
    }

    private static long getTimeout(WebDriverLocatable.LocateTimeout timeout) {
        return timeout.timeout() > 0L ? timeout.timeout() : 5000L;
    }

    private static class WebDriverListLocator
    extends DeprecatedApiBridge
    implements WebDriverLocatable {
        private WebElement webElement = null;
        private final By locator;
        private final int locatorIndex;
        private final WebDriverLocatable parent;

        public WebDriverListLocator(WebElement element, By locator, int locatorIndex, WebDriverLocatable parent) {
            Preconditions.checkArgument((locatorIndex >= 0 ? 1 : 0) != 0, (Object)("locator index is negative:" + locatorIndex));
            this.webElement = (WebElement)Preconditions.checkNotNull((Object)element);
            this.locatorIndex = locatorIndex;
            this.locator = (By)Preconditions.checkNotNull((Object)locator, (Object)"locator");
            this.parent = (WebDriverLocatable)Preconditions.checkNotNull((Object)parent, (Object)"parent");
        }

        @Override
        public By getLocator() {
            return null;
        }

        @Override
        public WebDriverLocatable getParent() {
            return this.parent;
        }

        @Override
        @Nonnull
        public SearchContext waitUntilLocated(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Preconditions.checkNotNull((Object)driver, (Object)"driver");
            Preconditions.checkNotNull((Object)timeout, (Object)"timeout");
            if (WebDriverLocators.isStale(this.webElement)) {
                try {
                    this.webElement = Poller.waitUntil(this.queryForElementInList(driver, timeout), Matchers.notNullValue(WebElement.class), WebDriverLocators.withinTimeout(timeout));
                }
                catch (AssertionError notLocated) {
                    throw new NoSuchElementException(new StringDescription().appendText("Unable to locate element in collection.").appendText("\nLocator: ").appendValue((Object)this.locator).appendText("\nLocator Index: ").appendValue((Object)this.locatorIndex).toString());
                }
            }
            return this.webElement;
        }

        @Override
        public boolean isPresent(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Preconditions.checkNotNull((Object)driver, (Object)"driver");
            Preconditions.checkNotNull((Object)timeout, (Object)"timeout");
            SearchContext searchContext = this.parent.waitUntilLocated(driver, timeout);
            List webElements = searchContext.findElements(this.locator);
            return this.locatorIndex <= webElements.size() - 1;
        }

        public String toString() {
            return StringConcat.asString("WebDriverListLocator[locator=", this.locator, ",index=", this.locatorIndex, "]");
        }

        private TimedQuery<WebElement> queryForElementInList(final WebDriver driver, WebDriverLocatable.LocateTimeout timeout) {
            return new AbstractTimedQuery<WebElement>(WebDriverLocators.getTimeout(timeout), timeout.pollInterval(), ExpirationHandler.RETURN_NULL){

                @Override
                protected boolean shouldReturn(WebElement currentEval) {
                    return true;
                }

                @Override
                protected WebElement currentValue() {
                    if (WebDriverListLocator.this.parent.isPresent(driver, 0)) {
                        List webElements = WebDriverListLocator.this.parent.waitUntilLocated(driver, 0).findElements(WebDriverListLocator.this.locator);
                        return WebDriverListLocator.this.locatorIndex < webElements.size() ? (WebElement)webElements.get(WebDriverListLocator.this.locatorIndex) : null;
                    }
                    return null;
                }
            };
        }
    }

    private static class WebDriverSingleLocator
    extends DeprecatedApiBridge
    implements WebDriverLocatable {
        private WebElement webElement = null;
        private boolean webElementLocated = false;
        private final By locator;
        private final WebDriverLocatable parent;

        public WebDriverSingleLocator(By locator, WebDriverLocatable parent) {
            this.locator = (By)Preconditions.checkNotNull((Object)locator, (Object)"locator");
            this.parent = (WebDriverLocatable)Preconditions.checkNotNull((Object)parent, (Object)"parent");
        }

        @Override
        public By getLocator() {
            return this.locator;
        }

        @Override
        public WebDriverLocatable getParent() {
            return this.parent;
        }

        @Override
        @Nonnull
        public SearchContext waitUntilLocated(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Preconditions.checkNotNull((Object)driver, (Object)"driver");
            Preconditions.checkNotNull((Object)timeout, (Object)"timeout");
            if (!this.webElementLocated || WebDriverLocators.isStale(this.webElement)) {
                try {
                    this.webElement = Poller.waitUntil(this.queryForSingleElement(driver, timeout), Matchers.notNullValue(WebElement.class), WebDriverLocators.withinTimeout(timeout));
                }
                catch (AssertionError notFound) {
                    throw new NoSuchElementException(new StringDescription().appendText("Unable to locate element by timeout.").appendText("\nLocator: ").appendValue((Object)this.locator).appendText("\nTimeout: ").appendValue((Object)timeout.timeout()).appendText("ms.").toString());
                }
                this.webElementLocated = true;
            }
            return this.webElement;
        }

        @Override
        public boolean isPresent(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Preconditions.checkNotNull((Object)driver, (Object)"driver");
            Preconditions.checkNotNull((Object)timeout, (Object)"timeout");
            try {
                return Check.elementExists((By)this.locator, (SearchContext)this.parent.waitUntilLocated(driver, timeout));
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }

        public String toString() {
            return StringConcat.asString("WebDriverSingleLocator[locator=", this.locator, "]");
        }

        private TimedQuery<WebElement> queryForSingleElement(final WebDriver driver, final WebDriverLocatable.LocateTimeout timeout) {
            return new AbstractTimedQuery<WebElement>(WebDriverLocators.getTimeout(timeout), timeout.pollInterval(), ExpirationHandler.RETURN_NULL){

                @Override
                protected boolean shouldReturn(WebElement currentEval) {
                    return true;
                }

                @Override
                protected WebElement currentValue() {
                    if (WebDriverSingleLocator.this.parent.isPresent(driver, WebDriverLocatable.LocateTimeout.zero(timeout.pollInterval()))) {
                        try {
                            return WebDriverSingleLocator.this.parent.waitUntilLocated(driver, WebDriverLocatable.LocateTimeout.zero(timeout.pollInterval())).findElement(WebDriverSingleLocator.this.locator);
                        }
                        catch (NoSuchElementException e) {
                            return null;
                        }
                    }
                    return null;
                }
            };
        }
    }

    private static class WebDriverRootLocator
    extends DeprecatedApiBridge
    implements WebDriverLocatable {
        private WebDriverRootLocator() {
        }

        @Override
        public By getLocator() {
            return null;
        }

        @Override
        public WebDriverLocatable getParent() {
            return null;
        }

        @Override
        @Nonnull
        public SearchContext waitUntilLocated(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Preconditions.checkNotNull((Object)driver, (Object)"driver");
            Preconditions.checkNotNull((Object)timeout, (Object)"timeout");
            return driver;
        }

        @Override
        public boolean isPresent(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Preconditions.checkNotNull((Object)driver, (Object)"driver");
            Preconditions.checkNotNull((Object)timeout, (Object)"timeout");
            return true;
        }
    }

    private static class WebDriverStaticLocator
    extends DeprecatedApiBridge
    implements WebDriverLocatable {
        private final WebElement element;

        public WebDriverStaticLocator(WebElement element) {
            this.element = element;
        }

        @Override
        public By getLocator() {
            if (WebDriverLocators.isStale(this.element)) {
                return null;
            }
            String id = this.element.getAttribute("id");
            if (id != null) {
                return By.id((String)id);
            }
            return null;
        }

        @Override
        public WebDriverLocatable getParent() {
            return WebDriverLocators.root();
        }

        @Override
        @Nonnull
        public SearchContext waitUntilLocated(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) throws NoSuchElementException {
            Preconditions.checkNotNull((Object)driver, (Object)"driver");
            Preconditions.checkNotNull((Object)timeout, (Object)"timeout");
            if (WebDriverLocators.isStale(this.element)) {
                throw new NoSuchElementException("WebElement got stale");
            }
            return this.element;
        }

        @Override
        public boolean isPresent(@Nonnull WebDriver driver, @Nonnull WebDriverLocatable.LocateTimeout timeout) {
            Preconditions.checkNotNull((Object)driver, (Object)"driver");
            Preconditions.checkNotNull((Object)timeout, (Object)"timeout");
            return !WebDriverLocators.isStale(this.element);
        }
    }

    private static abstract class DeprecatedApiBridge
    implements WebDriverLocatable {
        private DeprecatedApiBridge() {
        }

        @Override
        @Nonnull
        public final SearchContext waitUntilLocated(@Nonnull WebDriver driver, int timeoutInSeconds) throws NoSuchElementException {
            return this.waitUntilLocated(driver, new WebDriverLocatable.LocateTimeout.Builder().timeout(timeoutInSeconds, TimeUnit.SECONDS).build());
        }

        @Override
        public final boolean isPresent(@Nonnull WebDriver driver, int timeoutInSeconds) {
            return this.isPresent(driver, new WebDriverLocatable.LocateTimeout.Builder().timeout(timeoutInSeconds, TimeUnit.SECONDS).build());
        }
    }
}

