/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.components.aui;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.InvalidPageStateException;
import com.atlassian.pageobjects.components.TabbedComponent;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class AuiTabs
implements TabbedComponent {
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected PageElementFinder elementFinder;
    private final By rootLocator;
    private PageElement rootElement;

    public AuiTabs(By locator) {
        this.rootLocator = locator;
    }

    @Init
    public void initialize() {
        this.rootElement = this.elementFinder.find(this.rootLocator);
    }

    @Override
    public PageElement selectedTab() {
        List<PageElement> items = this.rootElement.find(By.className((String)"tabs-menu")).findAll(By.tagName((String)"li"));
        for (int i = 0; i < items.size(); ++i) {
            PageElement tab = items.get(i);
            if (!tab.hasClass("active-tab")) continue;
            return tab;
        }
        throw new InvalidPageStateException("A tab must be active.", (Object)this);
    }

    @Override
    public PageElement selectedView() {
        List<PageElement> panes = this.rootElement.findAll(By.className((String)"tabs-pane"));
        for (int i = 0; i < panes.size(); ++i) {
            PageElement pane = panes.get(i);
            if (!pane.hasClass("active-pane")) continue;
            return pane;
        }
        throw new InvalidPageStateException("A pane must be active", (Object)this);
    }

    @Override
    public List<PageElement> tabs() {
        return this.rootElement.find(By.className((String)"tabs-menu")).findAll(By.tagName((String)"li"));
    }

    public PageElement openTab(String tabText) {
        List<PageElement> tabs = this.rootElement.find(By.className((String)"tabs-menu")).findAll(By.tagName((String)"a"));
        for (int i = 0; i < tabs.size(); ++i) {
            if (!tabs.get(i).getText().equals(tabText)) continue;
            PageElement listItem = tabs.get(i);
            listItem.click();
            String tabViewHref = listItem.getAttribute("href");
            String tabViewClassName = tabViewHref.substring(tabViewHref.indexOf(35) + 1);
            PageElement pane = this.rootElement.find(By.id((String)tabViewClassName));
            Poller.waitUntilTrue(pane.timed().hasClass("active-pane"));
            return pane;
        }
        throw new InvalidPageStateException("Tab not found", (Object)this);
    }

    @Override
    public PageElement openTab(PageElement tab) {
        String tabIdentifier = tab.getText();
        return this.openTab(tabIdentifier);
    }
}

