package com.atlassian.pageobjects.elements;

import java.util.List;

/**
 * Represents a standard select HTML components.
 */
public interface SelectElement extends PageElement
{
    /**
     * All options
     *
     * @return all options of this select
     */
    List<Option> getAllOptions();

    /**
     * Selected option of this select.
     *
     * @return selected option of this select
     */
    Option getSelected();

    /**
     * Select given <tt>option</tt>. Options can be generated by using the (@Link Options) factory
     *
     * @param option option to select
     * @return this select instance
     */
    public SelectElement select(Option option);
}
