/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.binder;

import com.atlassian.annotations.Internal;
import com.atlassian.pageobjects.DelayedBinder;
import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.Tester;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.InvalidPageStateException;
import com.atlassian.pageobjects.binder.PageBindingException;
import com.atlassian.pageobjects.binder.PageBindingWaitException;
import com.atlassian.pageobjects.binder.PostInjectionProcessor;
import com.atlassian.pageobjects.binder.ValidateState;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.pageobjects.browser.IgnoreBrowser;
import com.atlassian.pageobjects.browser.RequireBrowser;
import com.atlassian.pageobjects.inject.AbstractInjectionConfiguration;
import com.atlassian.pageobjects.inject.ConfigurableInjectionContext;
import com.atlassian.pageobjects.inject.InjectionConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
@Internal
public final class InjectPageBinder
implements PageBinder,
ConfigurableInjectionContext {
    private final Tester tester;
    private final Supplier<String> baseUrlSupplier;
    private static final Logger log = LoggerFactory.getLogger(InjectPageBinder.class);
    private final Map<Class<?>, Class<?>> overrides = new HashMap();
    private volatile Module module;
    private volatile Injector injector;
    private volatile List<Binding<PostInjectionProcessor>> postInjectionProcessors;

    public InjectPageBinder(ProductInstance productInstance, Tester tester, Module ... modules) {
        this(productInstance::getBaseUrl, tester, modules);
    }

    public InjectPageBinder(Supplier<String> baseUrlSupplier, Tester tester, Module ... modules) {
        Objects.requireNonNull(baseUrlSupplier, "baseUrlSupplier can't be null");
        Objects.requireNonNull(tester, "tester can't be null");
        Objects.requireNonNull(modules, "modules can't be null");
        this.tester = tester;
        this.baseUrlSupplier = baseUrlSupplier;
        this.module = Modules.override((Module[])modules).with(new Module[]{new ThisModule()});
        this.injector = Guice.createInjector((Module[])new Module[]{this.module});
        this.initPostInjectionProcessors();
    }

    @Override
    public <P extends Page> P navigateToAndBind(Class<P> pageClass, Object ... args) {
        Objects.requireNonNull(pageClass, "pageClass can't be null");
        DelayedBinder<P> binder = this.delayedBind(pageClass, args);
        Page p = (Page)binder.get();
        this.visitUrl(p);
        return (P)((Page)binder.bind());
    }

    @Override
    public <P> P bind(Class<P> pageClass, Object ... args) {
        Objects.requireNonNull(pageClass, "pageClass cant be null");
        return this.delayedBind(pageClass, args).bind();
    }

    @Override
    public <P> DelayedBinder<P> delayedBind(Class<P> pageClass, Object ... args) {
        return new InjectableDelayedBind(Arrays.asList(new InstantiatePhase<P>(pageClass, args), new InjectPhase(), new WaitUntilPhase(), new ValidateStatePhase(), new InitializePhase()));
    }

    @Override
    public <P> void override(Class<P> oldClass, Class<? extends P> newClass) {
        Objects.requireNonNull(oldClass, "oldClass can't be null");
        Objects.requireNonNull(newClass, "newClass can't be null");
        this.overrides.put(oldClass, newClass);
    }

    @Override
    @Nonnull
    public <T> T getInstance(@Nonnull Class<T> type) {
        Objects.requireNonNull(type, "type was null");
        try {
            return (T)this.injector.getInstance(type);
        }
        catch (ConfigurationException | ProvisionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void injectStatic(final @Nonnull Class<?> targetClass) {
        this.injector.createChildInjector(new Module[]{new AbstractModule(){

            protected void configure() {
                this.requestStaticInjection(new Class[]{targetClass});
            }
        }});
    }

    @Override
    @Nonnull
    public <T> T inject(@Nonnull T target) {
        Objects.requireNonNull(target, "target");
        this.injector.injectMembers(target);
        return target;
    }

    @Override
    @Nonnull
    public InjectionConfiguration configure() {
        return new InjectConfiguration();
    }

    protected void visitUrl(@Nonnull Page page) {
        Objects.requireNonNull(page, "page");
        this.tester.gotoUrl(this.normalisedBaseUrl() + this.normalisedPath(page));
    }

    private void callLifecycleMethod(Object instance, Class<? extends Annotation> annotation) throws InvocationTargetException {
        Class<?> clazz = instance.getClass();
        List classes = ClassUtils.getAllSuperclasses(clazz);
        Collections.reverse(classes);
        classes.add(clazz);
        for (Class cl : classes) {
            for (Method method : cl.getDeclaredMethods()) {
                if (method.getAnnotation(annotation) == null) continue;
                Browser currentBrowser = this.getBrowser();
                if (this.isIgnoredBrowser(method, method.getAnnotation(IgnoreBrowser.class), currentBrowser) || !this.isRequiredBrowser(method, method.getAnnotation(RequireBrowser.class), currentBrowser)) continue;
                try {
                    method.setAccessible(true);
                    method.invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private Map<Key<?>, Binding<?>> collectBindings() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Injector current = this.injector; current != null; current = current.getParent()) {
            result.putAll(current.getAllBindings());
        }
        return result.build();
    }

    private Browser getBrowser() {
        try {
            return (Browser)((Object)this.injector.getInstance(Browser.class));
        }
        catch (Exception e) {
            return null;
        }
    }

    private void initPostInjectionProcessors() {
        ArrayList processors = Lists.newArrayList();
        for (Binding<?> binding : this.collectBindings().values()) {
            if (!PostInjectionProcessor.class.isAssignableFrom(binding.getKey().getTypeLiteral().getRawType())) continue;
            processors.add(binding);
        }
        this.postInjectionProcessors = Collections.unmodifiableList(processors);
    }

    private boolean isRequiredBrowser(Method method, RequireBrowser requireBrowser, Browser currentBrowser) {
        boolean result;
        if (currentBrowser == null || requireBrowser == null) {
            return true;
        }
        if (requireBrowser.value().length == 0) {
            return false;
        }
        EnumSet required = EnumSet.copyOf(ImmutableList.copyOf((Object[])requireBrowser.value()));
        boolean bl = result = required.contains((Object)currentBrowser) || required.contains((Object)Browser.ALL);
        if (!result) {
            log.info("{} ignored, since one of {} is required (reason: {}), but the current browser is {}", new Object[]{method.getName(), required, requireBrowser.reason(), currentBrowser});
        }
        return result;
    }

    private boolean isIgnoredBrowser(Method method, IgnoreBrowser ignoreBrowser, Browser currentBrowser) {
        if (currentBrowser == null || ignoreBrowser == null) {
            return false;
        }
        for (Browser browser : ignoreBrowser.value()) {
            if (browser != currentBrowser && browser != Browser.ALL) continue;
            log.info(method.getName() + " ignored, reason: " + ignoreBrowser.reason());
            return true;
        }
        return false;
    }

    private String normalisedBaseUrl() {
        String baseUrl = this.baseUrlSupplier.get();
        if (baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    private String normalisedPath(Page page) {
        String path = page.getUrl();
        if (!path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }

    void reconfigure(Module module) {
        this.module = Modules.override((Module[])new Module[]{this.module}).with(new Module[]{module});
        this.injector = Guice.createInjector((Module[])new Module[]{this.module});
        this.initPostInjectionProcessors();
    }

    private final class ThisModule
    extends AbstractModule {
        private ThisModule() {
        }

        protected void configure() {
            this.bind(PageBinder.class).toInstance((Object)InjectPageBinder.this);
        }
    }

    private final class InjectConfiguration
    extends AbstractInjectionConfiguration {
        private InjectConfiguration() {
        }

        @Override
        @Nonnull
        public ConfigurableInjectionContext finish() {
            InjectPageBinder.this.reconfigure(this.getModule());
            return InjectPageBinder.this;
        }

        Module getModule() {
            return binder -> {
                for (AbstractInjectionConfiguration.InterfaceToImpl intToImpl : this.interfacesToImpls) {
                    intToImpl.bind(binder);
                }
                for (AbstractInjectionConfiguration.InterfaceToInstance intToInstance : this.interfacesToInstances) {
                    intToInstance.bind(binder);
                }
            };
        }
    }

    private class InjectableDelayedBind<T>
    implements DelayedBinder<T> {
        private final LinkedList<Phase<T>> phases;
        private T pageObject = null;

        public InjectableDelayedBind(List<Phase<T>> phases) {
            this.phases = new LinkedList<Phase<T>>(phases);
        }

        @Override
        public boolean canBind() {
            try {
                this.advanceTo(InitializePhase.class);
                return true;
            }
            catch (PageBindingException ex) {
                return false;
            }
        }

        @Override
        @Nonnull
        public T get() {
            this.advanceTo(InstantiatePhase.class);
            return this.pageObject;
        }

        @Override
        @Nonnull
        public DelayedBinder<T> inject() {
            this.advanceTo(InjectPhase.class);
            return this;
        }

        @Override
        @Nonnull
        public DelayedBinder<T> waitUntil() {
            this.advanceTo(WaitUntilPhase.class);
            return this;
        }

        @Override
        @Nonnull
        public DelayedBinder<T> validateState() {
            this.advanceTo(ValidateStatePhase.class);
            return this;
        }

        @Override
        @Nonnull
        public T bind() {
            this.advanceTo(InitializePhase.class);
            return this.pageObject;
        }

        private void advanceTo(Class<? extends Phase> phaseClass) {
            boolean found = false;
            for (Phase phase : this.phases) {
                if (phase.getClass() != phaseClass) continue;
                found = true;
            }
            if (found) {
                while (!this.phases.isEmpty()) {
                    this.pageObject = this.phases.getFirst().execute(this.pageObject);
                    if (this.phases.removeFirst().getClass() != phaseClass) continue;
                    break;
                }
            } else {
                log.debug("Already advanced to state: " + phaseClass.getName());
            }
        }
    }

    private class InitializePhase<T>
    implements Phase<T> {
        private InitializePhase() {
        }

        @Override
        public T execute(T pageObject) {
            try {
                InjectPageBinder.this.callLifecycleMethod(pageObject, Init.class);
            }
            catch (InvocationTargetException e) {
                throw new PageBindingException(pageObject, e.getTargetException());
            }
            return pageObject;
        }
    }

    private class ValidateStatePhase<T>
    implements Phase<T> {
        private ValidateStatePhase() {
        }

        @Override
        public T execute(T pageObject) {
            try {
                InjectPageBinder.this.callLifecycleMethod(pageObject, ValidateState.class);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof InvalidPageStateException) {
                    throw (InvalidPageStateException)targetException;
                }
                throw new InvalidPageStateException(pageObject, targetException);
            }
            return pageObject;
        }
    }

    private class WaitUntilPhase<T>
    implements Phase<T> {
        private WaitUntilPhase() {
        }

        @Override
        public T execute(T pageObject) {
            try {
                InjectPageBinder.this.callLifecycleMethod(pageObject, WaitUntil.class);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof PageBindingWaitException) {
                    throw (PageBindingWaitException)targetException;
                }
                throw new PageBindingWaitException(pageObject, targetException);
            }
            return pageObject;
        }
    }

    private class InjectPhase<T>
    implements Phase<T> {
        private InjectPhase() {
        }

        @Override
        public T execute(T t) {
            this.autowireInjectables(t);
            T pageObject = t;
            for (Binding binding : InjectPageBinder.this.postInjectionProcessors) {
                pageObject = ((PostInjectionProcessor)binding.getProvider().get()).process(pageObject);
            }
            return pageObject;
        }

        private void autowireInjectables(Object instance) {
            try {
                InjectPageBinder.this.injector.injectMembers(instance);
            }
            catch (ConfigurationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private class InstantiatePhase<T>
    implements Phase<T> {
        private Class<T> pageClass;
        private final Object[] args;

        public InstantiatePhase(Class<T> pageClass, Object[] args) {
            this.pageClass = pageClass;
            this.args = args;
        }

        @Override
        public T execute(T t) {
            T instance;
            Class actualClass = this.pageClass;
            if (InjectPageBinder.this.overrides.containsKey(this.pageClass)) {
                actualClass = (Class)InjectPageBinder.this.overrides.get(this.pageClass);
            }
            try {
                instance = this.instantiate(actualClass, this.args);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e.getCause());
            }
            return instance;
        }

        private T instantiate(Class<T> clazz, Object[] args) throws InstantiationException, IllegalAccessException, InvocationTargetException {
            if (args != null && args.length > 0) {
                for (Constructor<?> c : clazz.getConstructors()) {
                    Class<?>[] paramTypes = c.getParameterTypes();
                    if (args.length != paramTypes.length) continue;
                    boolean match = true;
                    for (int x = 0; x < args.length; ++x) {
                        if (args[x] == null || ClassUtils.isAssignable(args[x].getClass(), paramTypes[x], (boolean)true)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    return (T)c.newInstance(args);
                }
            } else {
                try {
                    return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalArgumentException("Error invoking default constructor", e instanceof InvocationTargetException ? e.getCause() : e);
                }
            }
            throw new IllegalArgumentException("Cannot find constructor of " + clazz + " to match args: " + Arrays.asList(args));
        }
    }

    private static interface Phase<T> {
        public T execute(T var1);
    }
}

