/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects;

import com.atlassian.pageobjects.DefaultProductInstance;
import com.atlassian.pageobjects.Defaults;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.TestedProduct;
import com.atlassian.pageobjects.Tester;
import com.atlassian.pageobjects.util.Env;
import com.google.common.base.Supplier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class TestedProductFactory {
    public static <T extends TestedProduct<?>> Supplier<T> fromFactory(final Class<T> productClass) {
        return new Supplier<T>(){

            public T get() {
                return TestedProductFactory.create(productClass);
            }
        };
    }

    public static TestedProduct<?> create(String testedProductClass) {
        Class<?> clazz;
        try {
            clazz = TestedProductFactory.class.getClassLoader().loadClass(testedProductClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot find tested product class: " + testedProductClass);
        }
        return TestedProductFactory.create(clazz);
    }

    public static <P extends TestedProduct<?>> P create(Class<P> testedProductClass) {
        return TestedProductFactory.create(testedProductClass, TestedProductFactory.getDefaultInstanceId(testedProductClass), null);
    }

    public static <P extends TestedProduct<?>> P create(Class<P> testedProductClass, String instanceId, TesterFactory<?> testerFactory) {
        String baseUrl;
        String contextPath;
        int httpPort;
        String ampsBaseUrl = System.getProperty("baseurl." + instanceId);
        if (ampsBaseUrl != null) {
            httpPort = Integer.getInteger("http." + instanceId + ".port");
            contextPath = System.getProperty("context." + instanceId + ".path");
            baseUrl = ampsBaseUrl;
        } else {
            Defaults defaults = TestedProductFactory.getDefaultsAnnotation(testedProductClass);
            httpPort = defaults.httpPort();
            contextPath = defaults.contextPath();
            baseUrl = "http://" + Env.getVar("WEBDRIVER_TARGET_HOST", TestedProductFactory.getLocalHostName()) + ":" + Env.getVar("WEBDRIVER_TARGET_PORT", String.valueOf(httpPort)) + contextPath;
        }
        DefaultProductInstance instance = new DefaultProductInstance(baseUrl, instanceId, httpPort, contextPath);
        return TestedProductFactory.create(testedProductClass, instance, testerFactory);
    }

    private static String getDefaultInstanceId(Class<?> testedProductClass) {
        Defaults annotation = TestedProductFactory.getDefaultsAnnotation(testedProductClass);
        return annotation.instanceId();
    }

    private static Defaults getDefaultsAnnotation(Class<?> testedProductClass) {
        Defaults annotation = testedProductClass.getAnnotation(Defaults.class);
        if (annotation == null) {
            throw new IllegalArgumentException("The tested product class '" + testedProductClass.getName() + "' is missing the @Defaults annotation");
        }
        return annotation;
    }

    public static <P extends TestedProduct<?>> P create(Class<P> testedProductClass, ProductInstance productInstance, TesterFactory<?> testerFactory) {
        try {
            Constructor<P> c = testedProductClass.getConstructor(TesterFactory.class, ProductInstance.class);
            return (P)((TestedProduct)c.newInstance(testerFactory, productInstance));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static class SingletonTesterFactory<T extends Tester>
    implements TesterFactory<T> {
        private final T tester;

        public SingletonTesterFactory(T tester) {
            this.tester = tester;
        }

        @Override
        public T create() {
            return this.tester;
        }
    }

    public static interface TesterFactory<T> {
        public T create();
    }
}

