/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects;

import com.atlassian.annotations.PublicApi;
import com.atlassian.pageobjects.PageBinder;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public final class PageObjects {
    private PageObjects() {
        throw new AssertionError((Object)("Do not instantiate " + this.getClass().getSimpleName()));
    }

    @Nonnull
    public static <E, PO> Function<E, PO> bindTo(@Nonnull PageBinder binder, @Nonnull Class<PO> pageObjectClass, Object ... extraArguments) {
        return PageObjects.bindTo(binder, null, pageObjectClass, extraArguments);
    }

    @Nonnull
    public static <E, PO> Function<E, PO> bindTo(final @Nonnull PageBinder binder, @Nullable Class<E> inputType, final @Nonnull Class<PO> pageObjectClass, final Object ... extraArguments) {
        Preconditions.checkNotNull((Object)binder, (Object)"binder");
        Preconditions.checkNotNull(pageObjectClass, (Object)"pageObjectClass");
        Preconditions.checkNotNull((Object)extraArguments, (Object)"extraArguments");
        return new Function<E, PO>(){

            public PO apply(E element) {
                return binder.bind(pageObjectClass, ObjectArrays.concat(element, (Object[])extraArguments));
            }
        };
    }

    @Nonnull
    public static <E, EE> Iterable<EE> bind(@Nonnull PageBinder binder, @Nonnull Iterable<E> pageElements, @Nonnull Class<EE> pageObjectClass, Object ... extraArguments) {
        return Iterables.transform(pageElements, PageObjects.bindTo(binder, pageObjectClass, extraArguments));
    }
}

