package com.atlassian.security.xml;

import org.xml.sax.*;

import java.io.IOException;


/**
 * XMLReader which does not allow the entity resolver to be set, delegates down to the usual XMLReader
 *
 * @since 3.1.3
 */


class RestrictedXMLReader implements XMLReader
{

    private final XMLReader delegate;

    RestrictedXMLReader(XMLReader innerReader)
    {
        this.delegate = innerReader;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException
    {
        return delegate.getFeature(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException
    {
        if (RestrictedSAXParserFactory.checkFeatures(name, value))
        {
            delegate.setFeature(name, value);
        }
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException
    {
        return delegate.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException
    {
        delegate.setProperty(name, value);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver)
    {
        //silenty fail -- there are lots of users who try to reset the stream e.g. Digester.class
    }

    @Override
    public EntityResolver getEntityResolver()
    {
        return delegate.getEntityResolver();
    }

    @Override
    public void setDTDHandler(DTDHandler handler)
    {
        delegate.setDTDHandler(handler);
    }

    @Override
    public DTDHandler getDTDHandler()
    {
        return delegate.getDTDHandler();
    }

    @Override
    public void setContentHandler(ContentHandler handler)
    {
        delegate.setContentHandler(handler);
    }

    @Override
    public ContentHandler getContentHandler()
    {
        return delegate.getContentHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler handler)
    {
        delegate.setErrorHandler(handler);
    }

    @Override
    public ErrorHandler getErrorHandler()
    {
        return delegate.getErrorHandler();
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException
    {
        delegate.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException
    {
        delegate.parse(systemId);
    }
}
