/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.random;

import java.security.SecureRandom;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecureRandomFactory {
    private static final Logger log = LoggerFactory.getLogger(SecureRandomFactory.class);

    private SecureRandomFactory() {
    }

    public static SecureRandom newInstance() {
        log.debug("Starting creation of new SecureRandom");
        long start = System.currentTimeMillis();
        SecureRandom random = new SecureRandom();
        random.nextBytes(new byte[1]);
        long end = System.currentTimeMillis();
        log.debug("Finished creation new SecureRandom in {} ms", (Object)(end - start));
        return random;
    }

    public static Random newInsecureRandom() {
        Random r = new Random();
        r.setSeed(System.currentTimeMillis());
        return r;
    }
}

