/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.password;

import com.atlassian.security.password.PKCS5S2PasswordHashGenerator;
import com.atlassian.security.password.PasswordEncoder;
import com.atlassian.security.password.PasswordEncoderDecorator;
import com.atlassian.security.password.PasswordHashGenerator;
import com.atlassian.security.password.RandomSaltGenerator;
import com.atlassian.security.password.SaltGenerator;
import com.atlassian.security.password.StringUtils;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

public final class DefaultPasswordEncoder
implements PasswordEncoder {
    private static volatile PasswordEncoderDecorator DEFAULT_INSTANCE = new PasswordEncoderDecorator(new DefaultPasswordEncoder("PKCS5S2", new PKCS5S2PasswordHashGenerator(), new RandomSaltGenerator()));
    private static final int DEFAULT_SALT_LENGTH_BYTES = 16;
    private final String prefix;
    private final PasswordHashGenerator hashGenerator;
    private final SaltGenerator saltGenerator;

    public static PasswordEncoder getDefaultEncoder() {
        return DEFAULT_INSTANCE.getEncoder();
    }

    public static void setDefaultEncoder(PasswordEncoder passwordEncoder) {
        DEFAULT_INSTANCE.setEncoder(passwordEncoder);
    }

    public static PasswordEncoder getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static PasswordEncoder newInstance(String identifier, PasswordHashGenerator hashGenerator) {
        return new DefaultPasswordEncoder(identifier, hashGenerator, new RandomSaltGenerator());
    }

    public DefaultPasswordEncoder(String identifier, PasswordHashGenerator hashGenerator, SaltGenerator saltGenerator) {
        this.prefix = "{" + identifier + "}";
        this.hashGenerator = hashGenerator;
        this.saltGenerator = saltGenerator;
    }

    public final boolean canDecodePassword(String encodedPassword) {
        return encodedPassword != null && encodedPassword.startsWith(this.prefix);
    }

    public final String encodePassword(String rawPassword) throws IllegalArgumentException {
        Validate.notEmpty((String)rawPassword, (String)"Password must not be empty");
        byte[] salt = this.saltGenerator.generateSalt(this.getSaltLength());
        byte[] hash = this.hashGenerator.generateHash(StringUtils.getBytesUtf8(rawPassword), salt);
        String encodedPassword = this.toEncodedForm(salt, hash);
        return this.prependPrefix(encodedPassword);
    }

    private int getSaltLength() {
        if (this.hashGenerator.getRequiredSaltLength() > 0) {
            return this.hashGenerator.getRequiredSaltLength();
        }
        return 16;
    }

    public final boolean isValidPassword(String rawPassword, String prefixedEncodedPassword) throws IllegalArgumentException {
        Validate.notNull((Object)rawPassword);
        Validate.notNull((Object)prefixedEncodedPassword);
        if (!this.canDecodePassword(prefixedEncodedPassword)) {
            return false;
        }
        String encodedPassword = this.removePrefix(prefixedEncodedPassword);
        byte[] storedBytes = this.fromEncodedForm(encodedPassword);
        int saltLength = this.getSaltLength();
        byte[] salt = ArrayUtils.subarray((byte[])storedBytes, (int)0, (int)saltLength);
        byte[] storedHash = ArrayUtils.subarray((byte[])storedBytes, (int)saltLength, (int)storedBytes.length);
        byte[] hashAttempt = this.hashGenerator.generateHash(StringUtils.getBytesUtf8(rawPassword), salt);
        return Arrays.equals(storedHash, hashAttempt);
    }

    private String prependPrefix(String encodedPassword) {
        return this.prefix + encodedPassword;
    }

    private String removePrefix(String encodedPassword) {
        return encodedPassword.substring(this.prefix.length());
    }

    private byte[] fromEncodedForm(String encodedPassword) {
        return Base64.decodeBase64((byte[])StringUtils.getBytesUtf8(encodedPassword));
    }

    private String toEncodedForm(byte[] salt, byte[] hash) {
        byte[] saltAndHash = ArrayUtils.addAll((byte[])salt, (byte[])hash);
        byte[] base64 = Base64.encodeBase64((byte[])saltAndHash);
        return StringUtils.newStringUtf8(base64);
    }
}

