/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.rest.tests;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.refapp.ctk.AbstractRestTest;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.security.PublicKey;
import java.util.Collection;
import javax.ws.rs.core.UriBuilder;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.client.OAuthClient;
import net.oauth.client.OAuthResponseMessage;
import net.oauth.client.httpclient4.HttpClient4;
import net.oauth.http.HttpClient;
import org.junit.Assert;
import org.junit.Test;

public class WebSudoRestTest
extends AbstractRestTest {
    private static final String CONSUMER_KEY = "hardcoded-consumer";
    private static final String CONSUMER_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxZDzGUGk6rElyPm0iOua0lWg84nOlhQN1gmTFTIu5WFyQFHZF6OA4HX7xATttQZ6N21yKMakuNdRvEudyN/coUqe89r3Ae+rkEIn4tCxGpJWX205xVF3Cgsn8ICj6dLUFQPiWXouoZ7HG0sPKhCLXXOvUXmekivtyx4bxVFD9Zy4SQ7IHTx0V0pZYGc6r1gF0LqRmGVQDaQSbivigH4mlVwoAO9Tfccf+V00hYuSvntU+B1ZygMw2rAFLezJmnftTxPuehqWu9xS5NVsPsWgBL7LOi3oY8lhzOYjbMKDWM6zUtpOmWJA52cVJW6zwxCxE28/592IARxlJcq14tjwYwIDAQAB";
    private static final String CONSUMER_PRIVATE_KEY = "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDFkPMZQaTqsSXI+bSI65rSVaDzic6WFA3WCZMVMi7lYXJAUdkXo4DgdfvEBO21Bno3bXIoxqS411G8S53I39yhSp7z2vcB76uQQifi0LEaklZfbTnFUXcKCyfwgKPp0tQVA+JZei6hnscbSw8qEItdc69ReZ6SK+3LHhvFUUP1nLhJDsgdPHRXSllgZzqvWAXQupGYZVANpBJuK+KAfiaVXCgA71N9xx/5XTSFi5K+e1T4HVnKAzDasAUt7Mmad+1PE+56Gpa73FLk1Ww+xaAEvss6LehjyWHM5iNswoNYzrNS2k6ZYkDnZxUlbrPDELETbz/n3YgBHGUlyrXi2PBjAgMBAAECggEAAtMctqq6meRofuQbEa4Uq5cv0uuQeZLV086VPMNX6k2nXYYODYl36T2mmNndMC5khvBYpn6Ykk/5yjBmlB2nQOMZPLFPwMZVdJ2Nhm+naJLZC0o7fje49PrN2mFsdoZeI+LHVLIrgoILpLdBAz/zTiW+RvLvMnXQU4wdp4eO6i8J/Jwh0AY8rWsAGkk1mdZDwklPZZiwR3z+DDsDwPxFs8z6cE5rWJd2c/fhAQrHwOXyrQPsGyLHTOqS3BkjtEZrKRUlfdgV76VlThwrE5pAWuO0GPyfK/XCklwcNS1a5XxCOq3uUogWRhCsqUX6pYfAVS6xzX56MGDndQVlp7U5uQKBgQDyTDwhsNTWlmr++FyYrc6liSF9NEMBNDubrfLJH1kaOp590bE8fu3BG0UlkVcueUr05e33Kx1DMSFW72lR4dht1jruWsbFp6LlT3SUtyW2kcSet3fC8gySs2r6NncsZ2XFPoxTkalKpQ1atGoBe3XIKeT8RDZtgoLztQy7/7yANQKBgQDQvSHEKS5SttoFFf4YkUh2QmNX5m7XaDlTLB/3xjnlz8NWOweK1aVysb4t2Tct/SR4ZZ/qZDBlaaj4X9h9nlxxIMoXEyX6Ilc4tyCWBXxn6HFMSa/Rrq662Vzz228cPvW2XGOQWdj7IqwKO9cXgJkI5W84YtMtYrTPLDSjhfpxNwKBgGVCoPq/iSOpN0wZhbE1KiCaP8mwlrQhHSxBtS6CkF1a1DPm97g9n6VNfUdnB1Vf0YipsxrSBOe416MaaRyUUzwMBRLqExo1pelJnIIuTG+RWeeu6zkoqUKCAxpQuttu1uRo8IJYZLTSZ9NZhNfbveyKPa2D4G9B1PJ+3rSO+ztlAoGAZNRHQEMILkpHLBfAgsuC7iUJacdUmVauAiAZXQ1yoDDo0Xl4HjcvUSTMkccQIXXbLREh2w4EVqhgR4G8yIk7bCYDmHvWZ2o5KZtD8VO7EVI1kD0z4Zx4qKcggGbp2AINnMYqDetopX7NDbB0KNUklyiEvf72tUCtyDk5QBgSrqcCgYEAnlg3ByRd/qTFz/darZi9ehT68Cq0CS7/B9YvfnF7YKTAv6J2Hd/i9jGKcc27x6IMi0vf7zrqCyTMq56omiLdu941oWfsOnwffWRBInvrUWTj6yGHOYUtg2z4xESUoFYDeWwe/vX6TugL3oXSX3Sy3KWGlJhn/OmsN2fgajHRip0=";
    private ApplicationProperties appProp;
    private ServiceProviderConsumerStore consumerStore;

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.appProp = applicationProperties;
    }

    public void setConsumerStore(ServiceProviderConsumerStore consumerStore) {
        this.consumerStore = consumerStore;
    }

    @Test
    public void testGetWebSudoProtectedResourceRequiresWebSudo() throws Exception {
        Request request = this.createRequest(this.getResourceUri());
        this.makeRequestExpectingUnauthorized(request);
    }

    @Test
    public void testGetWebSudoProtectedResourceDoesPermitBasicAuthenticationToBypass() throws Exception {
        Request request = this.createRequestWithBasicAuthentication(this.getResourceUri());
        WebSudoRestTest.makeRequestExpectingText(request, "hello");
    }

    @Test
    public void testGetWebSudoProtectedResourcePermitsOAuthToByPassWebSudo() throws Exception {
        this.setUpOAuthConsumer();
        OAuthAccessor accessor = this.createAccessor(CONSUMER_KEY);
        OAuthClient client = new OAuthClient((HttpClient)new HttpClient4());
        OAuthMessage response = client.invoke(accessor, this.getResourceUri().toString(), (Collection)ImmutableMap.of((Object)"oauth_token", (Object)"").entrySet());
        Assert.assertEquals((long)200L, (long)((OAuthResponseMessage)response).getHttpResponse().getStatusCode());
        Assert.assertEquals((Object)"hello", (Object)response.readBodyAsString());
    }

    private URI getResourceUri() {
        return UriBuilder.fromUri((String)this.appProp.getBaseUrl()).path("rest").path("platform-ctk").path("latest").path("protecteddummy").path("hello").build(new Object[0]);
    }

    private void makeRequestExpectingUnauthorized(Request request) throws Exception {
        request.execute(new ResponseHandler(){

            public void handle(Response response) throws ResponseException {
                Assert.assertEquals((long)401L, (long)response.getStatusCode());
                Assert.assertTrue((boolean)response.getResponseBodyAsString().contains("This resource requires WebSudo"));
            }
        });
    }

    public static void makeRequestExpectingText(Request request, final String expectedText) throws Exception {
        request.execute(new ResponseHandler(){

            public void handle(Response response) throws ResponseException {
                Assert.assertEquals((long)200L, (long)response.getStatusCode());
                Assert.assertEquals((Object)expectedText, (Object)response.getResponseBodyAsString());
            }
        });
    }

    private void setUpOAuthConsumer() throws Exception {
        PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)CONSUMER_PUBLIC_KEY);
        Consumer hardcodedConsumer = Consumer.key((String)CONSUMER_KEY).name("Hardcoded Consumer").publicKey(publicKey).description("Hardcoded Consumer").callback(URI.create(this.appProp.getBaseUrl() + "/consumer/oauthcallback")).twoLOAllowed(true).executingTwoLOUser(this.infoProvider.getAdminUsername()).build();
        this.consumerStore.put(hardcodedConsumer);
    }

    private final OAuthAccessor createAccessor(String consumerKey) throws IOException {
        OAuthServiceProvider serviceProvider = new OAuthServiceProvider("", "", "");
        OAuthConsumer consumer = new OAuthConsumer("", consumerKey, null, serviceProvider);
        consumer.setProperty("RSA-SHA1.PrivateKey", (Object)CONSUMER_PRIVATE_KEY);
        consumer.setProperty("oauth_signature_method", (Object)"RSA-SHA1");
        return new OAuthAccessor(consumer);
    }
}

