/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.version;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.refapp.ctk.PlatformVersionSpecReader;
import com.atlassian.refapp.ctk.VersionStringComparator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.pkgscanner.DefaultOsgiVersionConverter;

public class PlatformVersionTest
extends SpringAwareTestCase {
    private static final DefaultOsgiVersionConverter VERSION_CONVERTER = new DefaultOsgiVersionConverter();
    private PackageAdmin packageAdmin;
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformVersionTest.class);

    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    @Test
    public void testAtlassianPlatformModulesSuppliedAtCorrectVersions() {
        String platformVersion = PlatformVersionSpecReader.getPlatformVersion();
        List<PlatformVersionSpecReader.VersionCheck> versionChecks = PlatformVersionSpecReader.getVersionChecks();
        StringBuilder sb = new StringBuilder();
        for (PlatformVersionSpecReader.VersionCheck check : versionChecks) {
            LOGGER.info("Validating bundle <{}>", (Object)check);
            if (check instanceof PlatformVersionSpecReader.ExportVersionCheck) {
                PlatformVersionSpecReader.ExportVersionCheck exportCheck = (PlatformVersionSpecReader.ExportVersionCheck)check;
                ExportedPackage export = this.packageAdmin.getExportedPackage(exportCheck.getPkg());
                if (export != null && VersionStringComparator.isSameOrNewerVersion(PlatformVersionTest.getOsgiVersion(exportCheck.getVersion()), export.getVersion().toString()) || export == null && exportCheck.isOptional()) continue;
                sb.append("Atlassian Platform ");
                sb.append(platformVersion);
                sb.append(" must have ");
                sb.append(exportCheck.getModuleName());
                sb.append("  version:");
                sb.append(exportCheck.getVersion());
                if (export != null) {
                    sb.append("  current version:");
                    sb.append(export.getVersion());
                } else {
                    sb.append(" (no current version)");
                }
                sb.append("\n");
                continue;
            }
            if (!(check instanceof PlatformVersionSpecReader.BundleVersionCheck)) continue;
            PlatformVersionSpecReader.BundleVersionCheck bundleCheck = (PlatformVersionSpecReader.BundleVersionCheck)check;
            Bundle[] bundles = this.packageAdmin.getBundles(bundleCheck.getBundleName(), null);
            boolean found = false;
            if (bundles != null) {
                for (Bundle bundle : bundles) {
                    if (!VersionStringComparator.isSameOrNewerVersion(PlatformVersionTest.getOsgiVersion(bundleCheck.getVersion()), bundle.getVersion().toString())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            sb.append("Atlassian Platform ");
            sb.append(platformVersion);
            sb.append(" must have ");
            sb.append(bundleCheck.getModuleName());
            sb.append("  version:");
            sb.append(bundleCheck.getVersion());
            sb.append("\n");
        }
        if (sb.length() > 0) {
            Assert.fail((String)sb.toString());
        }
    }

    private static String getOsgiVersion(String version) {
        return VERSION_CONVERTER.getVersion(version);
    }
}

