/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import org.junit.Assert;
import org.junit.Test;

public class TransactionTemplateTest
extends SpringAwareTestCase {
    private TransactionTemplate template;
    private boolean called = false;

    public void setTemplate(TransactionTemplate template) {
        this.template = template;
    }

    @Test
    public void testTransactionTemplateAvailable() {
        Assert.assertNotNull((String)"TransactionTemplate must be available to plugins", (Object)this.template);
    }

    @Test
    public void testCallBackIsExecuted() {
        String result = (String)this.template.execute(new TransactionCallback(){

            public Object doInTransaction() {
                TransactionTemplateTest.this.called = true;
                return "hi";
            }
        });
        Assert.assertTrue((String)"Should have executed callback in a transaction", (boolean)this.called);
        Assert.assertTrue((String)"Should have returned object from callback", (boolean)"hi".equals(result));
    }
}

