/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.api.user.UserManager;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Test;

public class ThreadLocalDelegateExecutorFactoryTest
extends SpringAwareTestCase {
    private ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    private UserManager userManager;

    public void setThreadLocalDelegateExecutorFactory(ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory) {
        this.threadLocalDelegateExecutorFactory = threadLocalDelegateExecutorFactory;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Test
    public void testUserManagerAvailable() {
        Assert.assertNotNull((String)"ThreadLocalDelegateExecutorFactory should be available to plugins", (Object)this.threadLocalDelegateExecutorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecution() throws ExecutionException, InterruptedException {
        Assert.assertTrue((String)"UserManager should be injectable", (this.userManager != null ? 1 : 0) != 0);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            ExecutorService wrappedExecutorService = this.threadLocalDelegateExecutorFactory.createExecutorService(executorService);
            Callable<String> userRetriever = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ThreadLocalDelegateExecutorFactoryTest.this.userManager.getRemoteUsername();
                }
            };
            String userInCallingThread = this.userManager.getRemoteUsername();
            String userInExecutorThread = wrappedExecutorService.submit(userRetriever).get();
            if (userInCallingThread != null) {
                Assert.assertTrue((String)("User in executor thread not equal to user in calling thread, expected: '" + userInCallingThread + "' but was '" + userInExecutorThread + "'."), (boolean)userInCallingThread.equals(userInExecutorThread));
            }
            Assert.assertTrue((String)"Executor thread not cleaned up", (executorService.submit(userRetriever).get() == null ? 1 : 0) != 0);
        }
        finally {
            executorService.shutdown();
        }
    }
}

