/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PluginSettingsTest
extends SpringAwareTestCase {
    private static final String VERY_LONG_STRING = StringUtils.repeat((String)"a", (int)99000);
    private PluginSettingsFactory factory;

    public void setFactory(PluginSettingsFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testPluginSettingsFactoryShouldBeAvailable() {
        Assert.assertNotNull((String)"PluginSettingsFactory should be available to plugins", (Object)this.factory);
    }

    @Test
    public void testStringMustBeSupported() {
        PluginSettings settings = this.factory.createGlobalSettings();
        Assert.assertTrue((String)"Global PluginSettings should be retrievable", (settings != null ? 1 : 0) != 0);
        settings.put("string", (Object)"foo");
        Assert.assertTrue((String)"Should be able to store and retrieve a string", (boolean)"foo".equals(settings.get("string")));
        settings.put("longstring", (Object)VERY_LONG_STRING);
        Assert.assertTrue((String)"Should be able to store and retrieve a string", (boolean)VERY_LONG_STRING.equals(settings.get("longstring")));
    }

    @Test
    public void testListMustBeSupported() {
        PluginSettings settings = this.factory.createGlobalSettings();
        ArrayList<String> oldList = new ArrayList<String>(Arrays.asList("foo", "faa", "fee", "fuu"));
        settings.put("list", oldList);
        List list = (List)settings.get("list");
        Assert.assertNotNull((String)"Should be able to store and retrieve a list", (Object)list);
        Assert.assertEquals((String)"Should be able to store and retrieve a list", (Object)list, oldList);
    }

    @Test
    public void testPropertiesMustBeSupported() {
        PluginSettings settings = this.factory.createGlobalSettings();
        Properties oldProp = new Properties();
        oldProp.setProperty("key1", "value1");
        oldProp.setProperty("key2", "value2");
        settings.put("prop", (Object)oldProp);
        Properties prop = (Properties)settings.get("prop");
        Assert.assertNotNull((String)"Should be able to store and retrieve a map", (Object)prop);
        Assert.assertTrue((String)"Should be able to store and retrieve a map", (boolean)oldProp.equals(prop));
    }

    @Test
    public void testMapMustBeSupported() {
        PluginSettings settings = this.factory.createGlobalSettings();
        HashMap<String, String> oldMap = new HashMap<String, String>();
        oldMap.put("key1", "value1");
        oldMap.put("key2", "value2");
        settings.put("map", oldMap);
        Map map = (Map)settings.get("map");
        Assert.assertNotNull((String)"Should be able to store and retrieve a map", (Object)map);
        Assert.assertTrue((String)"Should be able to store and retrieve a map", (boolean)((Object)map).equals(oldMap));
    }

    @Test
    public void testSpecialCharactersMustBeSupported() {
        PluginSettings settings = this.factory.createGlobalSettings();
        Map hashMap = new HashMap<String, String>();
        hashMap.put("key\n\t\f\r", "value\n\t\f\r");
        settings.put("hashMap", hashMap);
        hashMap = (Map)settings.get("hashMap");
        Assert.assertTrue((String)"Should be able to store and retrieve a real map", (hashMap != null && "value\n\t\f\r".equals(hashMap.get("key\n\t\f\r")) ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetWithNullKeyShouldThrowIllegalArgumentException() {
        this.factory.createGlobalSettings().get(null);
    }

    @Test
    public void testGetWithLongKeyShouldSucceed() {
        PluginSettings ps = this.factory.createGlobalSettings();
        ps.get(StringUtils.repeat((String)"a", (int)100));
        ps.get(StringUtils.repeat((String)"a", (int)101));
        ps.get(StringUtils.repeat((String)"a", (int)255));
        ps.get(StringUtils.repeat((String)"a", (int)256));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPutWithNullKeyShouldThrowIllegalArgumentException() {
        this.factory.createGlobalSettings().put(null, (Object)"foo");
    }

    @Test
    public void putWith100CharacterKeyShouldSucceed() {
        String key = StringUtils.repeat((String)"a", (int)100);
        PluginSettings ps = this.factory.createGlobalSettings();
        ps.put(key, (Object)"Value");
        Assert.assertEquals((Object)"Value", (Object)ps.get(key));
    }

    @Ignore(value="This behaviour is not required until REFAPP-229")
    @Test
    public void putWith255CharacterKeyShouldSucceed() {
        String key = StringUtils.repeat((String)"a", (int)255);
        PluginSettings ps = this.factory.createGlobalSettings();
        ps.put(key, (Object)"Value");
        Assert.assertEquals((Object)"Value", (Object)ps.get(key));
    }

    @Test(expected=IllegalArgumentException.class)
    public void putWithExcessiveKeyShouldThrowIllegalArgumentException() {
        this.factory.createGlobalSettings().put(StringUtils.repeat((String)"a", (int)256), (Object)"foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveWithNullKeyShouldThrowIllegalArgumentException() {
        this.factory.createGlobalSettings().remove(null);
    }

    @Test
    public void testRemoveWithLongKeyShouldSucceed() {
        PluginSettings ps = this.factory.createGlobalSettings();
        ps.remove(StringUtils.repeat((String)"a", (int)100));
        ps.remove(StringUtils.repeat((String)"a", (int)101));
        ps.remove(StringUtils.repeat((String)"a", (int)255));
        ps.remove(StringUtils.repeat((String)"a", (int)256));
    }
}

