package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import static org.junit.Assert.*;

/**
 * The thread local delegate executor factory should at least transfer the user state
 */
public class ThreadLocalContextManagerTest extends SpringAwareTestCase
{
    private ThreadLocalContextManager<Object> threadLocalContextManager;
    private Object oldContext;

    public void setThreadLocalContextManager(ThreadLocalContextManager<Object> threadLocalContextManager)
    {
        this.threadLocalContextManager = threadLocalContextManager;
    }

    @Before
    public void saveContext()
    {
        oldContext = threadLocalContextManager.getThreadLocalContext();
    }

    @Test
    public void testGetAndSetThreadLocalContext() throws ExecutionException, InterruptedException
    {
        final Object context = threadLocalContextManager.getThreadLocalContext();
        final ExecutorService executorService = Executors.newSingleThreadExecutor();
        try
        {
            final Future<Object> result = executorService.submit(new Callable<Object>() {

            @Override
                public Object call() throws Exception
                {
                    threadLocalContextManager.setThreadLocalContext(context);
                    return threadLocalContextManager.getThreadLocalContext();
                }
            });
            assertEquals(context, result.get());
        }
        finally
        {
            executorService.shutdown();
        }
    }

    @After
    public void cleanUp()
    {
        if (oldContext != null)
            threadLocalContextManager.setThreadLocalContext(oldContext);
        else
            threadLocalContextManager.clearThreadLocalContext();
        oldContext = null;
    }
}
