package com.atlassian.refapp.ctk;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.ImmutableSet;
import org.apache.commons.lang.StringUtils;

import java.security.Principal;
import java.util.Set;

/**
 * Default implementation of AppSpecificInfoProvider which allows values to be set through system properties.
 */
public class DefaultAppSpecificInfoProvider implements AppSpecificInfoProvider
{
    private final UserManager userManager;

    public DefaultAppSpecificInfoProvider(UserManager userManager) {
        this.userManager = userManager;
    }

    public String getAdminUsername()
    {
        return getRequiredProperty("platform.ctk.test.admin.username");
    }

    public String getAdminPassword()
    {
        return getRequiredProperty("platform.ctk.test.admin.password");
    }

    public String getAdminFullname()
    {
        return getRequiredProperty("platform.ctk.test.admin.fullname");
    }

    public String getMatchingSearchTerm()
    {
        return System.getProperty("platform.ctk.test.search.term");
    }

    @Override
    public UserKey getAdminUserKey()
    {
        UserProfile userProfile =  userManager.getUserProfile(getAdminUsername());
        return (userProfile != null) ? userProfile.getUserKey() : null;
    }

    /**
     * Matching strings can be supplied as comma separated values.
     */
    public Set<String> getExpectedMatchingContents()
    {
        String matches = System.getProperty("platform.ctk.test.search.matches");
        if (StringUtils.isNotBlank(matches))
        {
            return ImmutableSet.copyOf(StringUtils.split(matches, ','));
        }

        return null;
    }

    public String getValidLicense()
    {
        return getRequiredProperty("platform.ctk.test.validlicense");
    }

    private String getRequiredProperty(String key)
    {
        final String value = System.getProperty(key);

        if (value == null)
        {
            throw new IllegalStateException("System property [" + key + "] must be supplied for platform Ctk execution.");
        }

        return value;
    }
}