/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.refapp.ctk.sal;

import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.fileupload.CommonsFileUploadMultipartHandler;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.RequestFilePart;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHandler;

public class RequestFactoryTest
extends SpringAwareTestCase {
    private static final String MESSAGE = "Hello World!";
    private RequestFactory<Request<?, ?>> requestFactory;
    private boolean passed = false;
    private static File testFile;

    public void setRequestFactory(RequestFactory<Request<?, ?>> requestFactory) {
        this.requestFactory = requestFactory;
    }

    @BeforeClass
    public static void before() throws Exception {
        testFile = File.createTempFile("refapp-ctk-rest-test", "tmp");
        FileUtils.writeStringToFile((File)testFile, (String)"test");
    }

    @AfterClass
    public static void after() throws Exception {
        if (!testFile.delete()) {
            testFile.deleteOnExit();
        }
    }

    @Test
    public void testRequestFactoryAvailable() {
        Assert.assertNotNull((String)"RequestFactory must be available to plugins", this.requestFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteUnauthenticatedRequest() throws Exception {
        Server server = new Server(0);
        ServletHandler handler = new ServletHandler();
        handler.addServletWithMapping(HelloServlet.class, "/*");
        server.setHandler((Handler)handler);
        try {
            server.start();
            Request request = this.requestFactory.createRequest(Request.MethodType.GET, "http://localhost:" + this.getActivePort(server));
            request.execute(new ResponseHandler(){

                public void handle(Response response) throws ResponseException {
                    RequestFactoryTest.this.passed = response.getResponseBodyAsString().contains(RequestFactoryTest.MESSAGE);
                }
            });
            Assert.assertTrue((String)"Should be able to get result from http", (boolean)this.passed);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCanSendMultipartPostRequest() throws Exception {
        Server server = new Server(0);
        ServletHandler handler = new ServletHandler();
        handler.addServletWithMapping(SetFilesServlet.class, "/*");
        server.setHandler((Handler)handler);
        try {
            server.start();
            Request request = this.requestFactory.createRequest(Request.MethodType.POST, "http://localhost:" + this.getActivePort(server));
            request.setFiles(Collections.singletonList(new RequestFilePart(testFile, "testFile")));
            request.execute(new ResponseHandler(){

                public void handle(Response response) throws ResponseException {
                    Assert.assertTrue((boolean)response.isSuccessful());
                }
            });
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCanSendMultipartPutRequest() throws Exception {
        Server server = new Server(0);
        ServletHandler handler = new ServletHandler();
        handler.addServletWithMapping(SetFilesServlet.class, "/*");
        server.setHandler((Handler)handler);
        try {
            server.start();
            Request request = this.requestFactory.createRequest(Request.MethodType.PUT, "http://localhost:" + this.getActivePort(server));
            request.setFiles(Collections.singletonList(new RequestFilePart(testFile, "testFile")));
            request.execute(new ResponseHandler(){

                public void handle(Response response) throws ResponseException {
                    Assert.assertTrue((boolean)response.isSuccessful());
                }
            });
        }
        finally {
            server.stop();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullSetFiles() throws Exception {
        Request request = this.requestFactory.createRequest(Request.MethodType.PUT, "http://localhost");
        request.setFiles(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFilesWithGetRequest() throws Exception {
        List<RequestFilePart> fileParts = Collections.singletonList(new RequestFilePart(testFile, "testFile"));
        Request request = this.requestFactory.createRequest(Request.MethodType.GET, "http://localhost");
        request.setFiles(fileParts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFilesWithHeadRequest() throws Exception {
        List<RequestFilePart> fileParts = Collections.singletonList(new RequestFilePart(testFile, "testFile"));
        Request request = this.requestFactory.createRequest(Request.MethodType.HEAD, "http://localhost");
        request.setFiles(fileParts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFilesWithDeleteRequest() throws Exception {
        List<RequestFilePart> fileParts = Collections.singletonList(new RequestFilePart(testFile, "testFile"));
        Request request = this.requestFactory.createRequest(Request.MethodType.DELETE, "http://localhost");
        request.setFiles(fileParts);
    }

    @Test(expected=IllegalStateException.class)
    public void testSetFilesAfterSetRequestBody() throws Exception {
        List<RequestFilePart> fileParts = Collections.singletonList(new RequestFilePart(testFile, "testFile"));
        Request request = this.requestFactory.createRequest(Request.MethodType.POST, "http://localhost");
        request.setRequestBody("body");
        request.setFiles(fileParts);
    }

    public void testSetFilesReturnsItself() throws Exception {
        List<RequestFilePart> fileParts = Collections.singletonList(new RequestFilePart(testFile, "testFile"));
        Request request = this.requestFactory.createRequest(Request.MethodType.POST, "http://localhost");
        Assert.assertEquals((Object)request, (Object)request.setFiles(fileParts));
    }

    private int getActivePort(Server server) {
        return server.getConnectors()[0].getLocalPort();
    }

    public static class HelloServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            res.setContentType("text/html;charset=utf-8");
            PrintWriter out = res.getWriter();
            out.println(RequestFactoryTest.MESSAGE);
            out.close();
        }
    }

    public static class SetFilesServlet
    extends HttpServlet {
        public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            this.handleMultipart(req, res);
        }

        public void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            this.handleMultipart(req, res);
        }

        private void handleMultipart(HttpServletRequest req, HttpServletResponse res) throws IOException {
            CommonsFileUploadMultipartHandler handler = new CommonsFileUploadMultipartHandler(1000L, 1000L);
            FilePart filePart = handler.getFilePart(req, "testFile");
            if (!IOUtils.toString((InputStream)filePart.getInputStream()).equals("test")) {
                res.setStatus(400);
            }
        }
    }
}

