package com.atlassian.refapp.ctk.webhooks;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.functest.junit.SpringAwareTestCase;
import com.atlassian.refapp.ctk.WebHookTestEvent;
import com.atlassian.refapp.ctk.WebHookServlet;
import org.junit.Test;

import static org.junit.Assert.*;

public final class WebHookOnEventsTest extends SpringAwareTestCase
{
    private EventPublisher eventPublisher;

    @Test
    public void testWebHookConfiguredFromProvider() throws Exception
    {
        assertFalse(WebHookServlet.hasHooks());

        final String eventValue = "This is my value!";
        eventPublisher.publish(new WebHookTestEvent(eventValue));

        final WebHookServlet.Hook hook = WebHookServlet.waitAndPop();
        assertNotNull(hook);
        assertTrue(hook.body.contains(eventValue));
        assertFalse(WebHookServlet.hasHooks());
    }

    public void setEventPublisher(EventPublisher eventPublisher)
    {
        this.eventPublisher = eventPublisher;
    }
}
