package com.atlassian.refapp.ctk.aui;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;

/**
 * A servlet to server up links to the AUI resources. This will be checked by {@link AuiResourcesPresentTest}.
 */
public class ServletUsingAuiResources extends HttpServlet
{
    WebResourceManager resourceLocator;

    public ServletUsingAuiResources(WebResourceManager locator)
    {
        this.resourceLocator = locator;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
    {
        resp.setContentType("text/plain; charset=utf-8");

        PrintWriter pw = resp.getWriter();

        resourceLocator.requireResource("com.atlassian.auiplugin:ajs");

        resourceLocator.includeResources(pw, UrlMode.ABSOLUTE);

        pw.close();
    }
}
