/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.v2search.sort;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.cql.lucene.comparator.TransformingStringFieldComparatorSource;
import com.atlassian.confluence.plugins.cql.spi.sort.BaseUserSort;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.lucene.LuceneSortMapper;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.Entity;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class UserSortMapper
implements LuceneSortMapper<BaseUserSort> {
    private final LocaleManager localeManager;
    private final UserAccessor userAccessor;
    private final CacheLoader<String, ConfluenceUser> getUserByKey = new CacheLoader<String, ConfluenceUser>(){

        public ConfluenceUser load(@Nonnull String userKey) {
            Preconditions.checkNotNull((Object)userKey);
            return UserSortMapper.this.userAccessor.getUserByKey(new UserKey(userKey));
        }
    };

    public UserSortMapper(@ComponentImport LocaleManager localeManager, @ComponentImport UserAccessor userAccessor) {
        this.localeManager = localeManager;
        this.userAccessor = userAccessor;
    }

    public Sort convertToLuceneSort(BaseUserSort userSort) {
        boolean reverse = SearchSort.Order.DESCENDING.equals((Object)userSort.getOrder());
        if (userSort.getUserSortType().equals((Object)BaseUserSort.UserSortType.USERKEY)) {
            return new Sort(new SortField(userSort.getFieldName(), SortField.Type.STRING, reverse));
        }
        return new Sort(new SortField(userSort.getFieldName(), this.getFieldComparator(userSort), reverse));
    }

    private FieldComparatorSource getFieldComparator(BaseUserSort userSort) {
        Function<ConfluenceUser, String> transformerFunction = this.getStringValueFunction(userSort.getUserSortType());
        return new TransformingStringFieldComparatorSource<ConfluenceUser>(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()), this.getUserByKey, transformerFunction);
    }

    private Function<ConfluenceUser, String> getStringValueFunction(BaseUserSort.UserSortType sortType) {
        switch (sortType) {
            case FULLNAME: {
                return User::getFullName;
            }
            case EMAIL: {
                return input -> Strings.nullToEmpty((String)input.getEmail());
            }
            case USERNAME: {
                return Entity::getName;
            }
        }
        throw new UnsupportedOperationException("Sorting not implemented for " + sortType);
    }
}

