/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.lucene.comparator;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.util.BytesRef;

public class TransformingStringFieldComparatorSource<T>
extends FieldComparatorSource {
    private final java.util.function.Function<T, CollationKey> stringValueFunction;
    private final LoadingCache<String, T> valueLoader;
    private final Collator collator;

    @Deprecated
    public TransformingStringFieldComparatorSource(Locale locale, CacheLoader<String, T> loader, Function<T, String> transformer) {
        this(Collator.getInstance((Locale)Preconditions.checkNotNull((Object)locale, (Object)"locale is required")), loader, (java.util.function.Function<T, String>)transformer);
    }

    @Deprecated
    public TransformingStringFieldComparatorSource(Collator newCollator, CacheLoader<String, T> loader, Function<T, String> transformer) {
        this(newCollator, loader, (java.util.function.Function<T, String>)transformer);
    }

    public TransformingStringFieldComparatorSource(Locale locale, CacheLoader<String, T> loader, java.util.function.Function<T, String> stringValueFunction) {
        this(Collator.getInstance((Locale)Preconditions.checkNotNull((Object)locale, (Object)"locale is required")), loader, stringValueFunction);
    }

    public TransformingStringFieldComparatorSource(Collator collator, CacheLoader<String, T> loader, java.util.function.Function<T, String> stringValueFunction) {
        this.valueLoader = CacheBuilder.newBuilder().build(loader);
        this.stringValueFunction = stringValueFunction.andThen(collator::getCollationKey);
        this.collator = collator;
    }

    public FieldComparator<?> newComparator(final String fieldname, final int numHits, int sortPos, boolean reversed) {
        return new FieldComparator<Object>(){
            private BinaryDocValues docs;
            private CollationKey[] sortValues;
            private CollationKey bottomSortValue;
            private Ordering<CollationKey> ordering;
            private BytesRef copyBuffer;
            {
                this.sortValues = new CollationKey[numHits];
                this.ordering = Ordering.natural().nullsLast();
                this.copyBuffer = new BytesRef();
            }

            public int compare(int slot1, int slot2) {
                return this.ordering.compare((Object)this.sortValues[slot1], (Object)this.sortValues[slot2]);
            }

            public void setBottom(int slot) {
                this.bottomSortValue = this.sortValues[slot];
            }

            public int compareBottom(int doc) {
                return this.ordering.compare((Object)this.bottomSortValue, (Object)this.getSortValue(doc));
            }

            public void copy(int slot, int doc) {
                this.sortValues[slot] = this.getSortValue(doc);
            }

            public FieldComparator<Object> setNextReader(AtomicReaderContext context) throws IOException {
                this.docs = FieldCache.DEFAULT.getTerms(context.reader(), fieldname);
                return this;
            }

            public Object value(int slot) {
                return this.sortValues[slot];
            }

            public int compareDocToValue(int doc, Object value) {
                return this.ordering.compare((Object)this.getSortValue(doc), (Object)((CollationKey)value));
            }

            private CollationKey getSortValue(int doc) {
                try {
                    this.docs.get(doc, this.copyBuffer);
                    String userKey = this.copyBuffer.utf8ToString();
                    if (Strings.isNullOrEmpty((String)userKey)) {
                        return null;
                    }
                    Object user = TransformingStringFieldComparatorSource.this.valueLoader.get((Object)userKey);
                    if (user == null) {
                        return null;
                    }
                    return (CollationKey)TransformingStringFieldComparatorSource.this.stringValueFunction.apply(user);
                }
                catch (ExecutionException ex) {
                    if (ex.getCause() != null) {
                        throw Throwables.propagate((Throwable)ex.getCause());
                    }
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        };
    }
}

