/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.impl;

import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ActiveUserSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ArchivedSpacesSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.BooleanSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ContentStatusFilter;
import com.atlassian.confluence.search.v2.searchfilter.ExcludedContentTypeSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.SiteSearchPermissionsSearchFilter;
import com.atlassian.confluence.setup.settings.CollaborativeEditingHelper;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchFilterFactory {
    private final SpaceManager spaceManager;
    private final CollaborativeEditingHelper collaborativeEditingHelper;
    private static final ImmutableList<SearchFilter> BASE_FILTERS = ImmutableList.of((Object)SiteSearchPermissionsSearchFilter.getInstance(), (Object)ExcludedContentTypeSearchFilter.getInstance(), (Object)ActiveUserSearchFilter.getInstance());

    @Autowired
    public SearchFilterFactory(@ComponentImport SpaceManager spaceManager, @ComponentImport CollaborativeEditingHelper collaborativeEditingHelper) {
        this.spaceManager = spaceManager;
        this.collaborativeEditingHelper = collaborativeEditingHelper;
    }

    public SearchFilter makeFilter(boolean includeArchivedSpaces, List<ContentStatus> contentStatuses) {
        Objects.requireNonNull(contentStatuses);
        ArrayList filters = Lists.newArrayList(BASE_FILTERS);
        if (!includeArchivedSpaces) {
            filters.add(new ArchivedSpacesSearchFilter(false, this.spaceManager));
        }
        if (contentStatuses.isEmpty() || this.collaborativeEditingHelper.getEditMode("").equals("legacy")) {
            filters.add(ContentStatusFilter.getDefaultStatusInstance());
        } else {
            filters.add(new ContentStatusFilter(contentStatuses));
        }
        return (SearchFilter)BooleanSearchFilter.builder().addMust((Collection)filters).build();
    }
}

