/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.fields;

import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.SpaceCategoryQuery;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.EqualityFieldHandler;
import com.atlassian.querylang.fields.expressiondata.EqualityExpressionData;
import com.atlassian.querylang.fields.expressiondata.ExpressionData;
import com.atlassian.querylang.fields.expressiondata.SetExpressionData;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;

public class SpaceTypeFieldHandler
extends BaseFieldHandler
implements EqualityFieldHandler<String, V2SearchQueryWrapper> {
    private static final String FIELD_NAME = "space.type";
    private Function<String, SpaceCategoryEnum> categoryFromValue = new Function<String, SpaceCategoryEnum>(){

        public SpaceCategoryEnum apply(String value) {
            SpaceType type = SpaceType.forName((String)value);
            if (type.equals((Object)SpaceType.GLOBAL)) {
                return SpaceCategoryEnum.GLOBAL;
            }
            if (type.equals((Object)SpaceType.PERSONAL)) {
                return SpaceCategoryEnum.PERSONAL;
            }
            String lowerCase = value.toLowerCase();
            if (lowerCase.equals("favourite") || lowerCase.equals("favorite")) {
                return SpaceCategoryEnum.FAVOURITES;
            }
            throw new BadRequestException("Unsupported space type : " + value);
        }
    };

    public SpaceTypeFieldHandler() {
        super(FIELD_NAME);
    }

    public V2SearchQueryWrapper build(SetExpressionData expressionData, Iterable<String> values) {
        this.validateSupportedOp((Enum)((SetExpressionData.Operator)expressionData.getOperator()), Sets.newHashSet((Object[])new SetExpressionData.Operator[]{SetExpressionData.Operator.IN, SetExpressionData.Operator.NOT_IN}));
        SpaceCategoryQuery query = new SpaceCategoryQuery((Set)Sets.newHashSet((Iterable)Iterables.transform(values, this.categoryFromValue)));
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, (ExpressionData)expressionData);
    }

    public V2SearchQueryWrapper build(EqualityExpressionData expressionData, String value) {
        this.validateSupportedOp((Enum)((EqualityExpressionData.Operator)expressionData.getOperator()), Sets.newHashSet((Object[])new EqualityExpressionData.Operator[]{EqualityExpressionData.Operator.EQUALS, EqualityExpressionData.Operator.NOT_EQUALS}));
        SpaceCategoryEnum category = (SpaceCategoryEnum)this.categoryFromValue.apply((Object)value);
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)new SpaceCategoryQuery(category), (ExpressionData)expressionData);
    }
}

