/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.fields;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ChildContentService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.plugins.cql.v2search.query.ContentIdQuery;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.MatchNoDocsQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.querylang.fields.BaseFieldHandler;
import com.atlassian.querylang.fields.EqualityFieldHandler;
import com.atlassian.querylang.fields.expressiondata.EqualityExpressionData;
import com.atlassian.querylang.fields.expressiondata.ExpressionData;
import com.atlassian.querylang.fields.expressiondata.SetExpressionData;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ParentFieldHandler
extends BaseFieldHandler
implements EqualityFieldHandler<String, V2SearchQueryWrapper> {
    static final int MAX_TO_FETCH = 1001;
    private final ContentService contentService;
    private final ChildContentService childContentService;

    public ParentFieldHandler(@ComponentImport ContentService contentService, @ComponentImport ChildContentService childContentService) {
        super("parent");
        this.contentService = contentService;
        this.childContentService = childContentService;
    }

    public V2SearchQueryWrapper build(SetExpressionData expressionData, Iterable<String> values) {
        this.validateSupportedOp((Enum)((SetExpressionData.Operator)expressionData.getOperator()), Collections.emptySet());
        return null;
    }

    public V2SearchQueryWrapper build(EqualityExpressionData expressionData, String value) {
        Collection<Content> children;
        this.validateSupportedOp((Enum)((EqualityExpressionData.Operator)expressionData.getOperator()), Sets.newHashSet((Object[])new EqualityExpressionData.Operator[]{EqualityExpressionData.Operator.EQUALS, EqualityExpressionData.Operator.NOT_EQUALS}));
        ContentId contentId = (ContentId)V2FieldHandlerHelper.stringToContentId.apply((Object)value);
        Content parent = this.contentService.find(new Expansion[0]).withId(contentId).fetch().orElse(null);
        if (parent == null) {
            return V2FieldHandlerHelper.wrapV2Search((SearchQuery)MatchNoDocsQuery.getInstance(), (ExpressionData)expressionData);
        }
        if (ContentType.PAGE.equals((Object)parent.getType())) {
            children = this.fetchChildren(this.childContentService.findContent(contentId, new Expansion[0]), ContentType.PAGE);
        } else if (ContentType.COMMENT.equals((Object)parent.getType())) {
            children = this.fetchChildren(this.childContentService.findContent(contentId, new Expansion[0]), ContentType.COMMENT);
        } else {
            return V2FieldHandlerHelper.wrapV2Search((SearchQuery)MatchNoDocsQuery.getInstance(), (ExpressionData)expressionData);
        }
        if (children.isEmpty()) {
            return V2FieldHandlerHelper.wrapV2Search((SearchQuery)MatchNoDocsQuery.getInstance(), (ExpressionData)expressionData);
        }
        ContentIdQuery query = new ContentIdQuery(children.stream().map(Content::getId).collect(Collectors.toList()));
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)query, (ExpressionData)expressionData);
    }

    private Collection<Content> fetchChildren(ChildContentService.ChildContentFinder finder, ContentType type) {
        PageResponse response;
        Stream results = Stream.empty();
        SimplePageRequest pageRequest = new SimplePageRequest(0, 1001);
        int count = 0;
        do {
            response = finder.fetchMany(type, (PageRequest)pageRequest);
            results = Stream.concat(results, response.getResults().stream());
            int offset = response.getPageRequest().getStart() + response.getPageRequest().getLimit();
            pageRequest = new SimplePageRequest(offset, 1001 - offset);
        } while (response.hasMore() && (count += response.size()) < 1001);
        return results.collect(Collectors.toList());
    }
}

