/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.v2search.sort;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.cql.lucene.comparator.TransformingStringFieldComparatorSource;
import com.atlassian.confluence.plugins.cql.v2search.sort.ContentIdSort;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.lucene.LuceneSortMapper;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Functions;
import com.google.common.cache.CacheLoader;
import java.text.Collator;
import java.text.ParseException;
import javax.annotation.Nonnull;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class ContentIdSortMapper
implements LuceneSortMapper {
    private final LocaleManager localeManager;
    private final CacheLoader<String, Object> getId = new CacheLoader<String, Object>(){

        public Object load(@Nonnull String handleFieldValue) throws ParseException {
            HibernateHandle hibernateHandle = new HibernateHandle(handleFieldValue);
            return hibernateHandle.getId();
        }
    };

    public ContentIdSortMapper(@ComponentImport LocaleManager localeManager, @ComponentImport UserAccessor userAccessor) {
        this.localeManager = localeManager;
    }

    public Sort convertToLuceneSort(SearchSort searchSort) {
        boolean reverse = SearchSort.Order.DESCENDING.equals((Object)searchSort.getOrder());
        ContentIdSort contentIdSort = (ContentIdSort)searchSort;
        return new Sort(new SortField("handle", this.getFieldComparator(contentIdSort), reverse));
    }

    private FieldComparatorSource getFieldComparator(ContentIdSort contentIdSort) {
        return new TransformingStringFieldComparatorSource<Object>(Collator.getInstance(), this.getId, Functions.toStringFunction());
    }
}

