/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.cql.v2search.query;

import com.atlassian.confluence.plugins.cql.v2search.query.UserQuery;
import com.atlassian.confluence.search.lucene.LuceneQueryParserFactory;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class UserQueryMapper
implements LuceneQueryMapper<UserQuery> {
    private LuceneQueryParserFactory luceneQueryParserFactory;

    public Query convertToLuceneQuery(UserQuery userQuery) {
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add(new BooleanClause(this.createFieldQuery(userQuery), BooleanClause.Occur.MUST));
        booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term("type", ContentTypeEnum.PERSONAL_INFORMATION.getRepresentation())), BooleanClause.Occur.MUST));
        return booleanQuery;
    }

    private Query createFieldQuery(UserQuery userQuery) {
        switch (userQuery.getUserQueryType()) {
            case FULLNAME: {
                return this.makeTextQuery(userQuery, "fullName");
            }
            case USERKEY: {
                return this.makeTermQuery(userQuery, "userKey");
            }
            case USERNAME: {
                return this.makeTermQuery(userQuery, "username");
            }
        }
        throw new UnsupportedOperationException("unrecognised enum value " + (Object)((Object)userQuery.getUserQueryType()));
    }

    private Query makeTermQuery(UserQuery query, String indexField) {
        return new TermQuery(new Term(indexField, query.getRawQuery()));
    }

    private Query makeTextQuery(UserQuery query, String indexField) {
        StandardQueryParser queryParser = this.luceneQueryParserFactory.createQueryParser();
        try {
            return queryParser.parse(query.getRawQuery(), indexField);
        }
        catch (QueryNodeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setLuceneQueryParserFactory(LuceneQueryParserFactory luceneQueryParserFactory) {
        this.luceneQueryParserFactory = luceneQueryParserFactory;
    }
}

