/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class MetricTag {
    private final String key;
    private final String value;

    private MetricTag(String key, String value) {
        this.key = Objects.requireNonNull(key);
        this.value = Objects.requireNonNull(value);
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricTag)) {
            return false;
        }
        MetricTag metricTag = (MetricTag)o;
        return this.key.equals(metricTag.key) && this.value.equals(metricTag.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    @Nonnull
    public static MetricTag of(String key, String value) {
        return new MetricTag(key, value);
    }

    @Nonnull
    public static MetricTag of(String key, int value) {
        return new MetricTag(key, String.valueOf(value));
    }

    @Nonnull
    public static MetricTag of(String key, boolean value) {
        return new MetricTag(key, String.valueOf(value));
    }
}

