/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.strategy.impl;

import com.atlassian.util.profiling.UtilTimerLogger;
import com.atlassian.util.profiling.UtilTimerStack;
import com.atlassian.util.profiling.strategy.ProfilingStrategy;
import com.atlassian.util.profiling.strategy.impl.ProfilingTimerBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackProfilingStrategy
implements ProfilingStrategy {
    private static final String ACTIVATE_MEMORY_PROPERTY = "atlassian.profile.activate.memory";
    private static final Logger log = LoggerFactory.getLogger(UtilTimerStack.class);
    private static final String MAX_FRAME_COUNT = "atlassian.profile.maxframecount";
    private static final String MIN_TIME = "atlassian.profile.mintime";
    private static final String MIN_TOTAL_TIME = "atlassian.profile.mintotaltime";
    private static final String ACTIVATE_PROPERTY = "atlassian.profile.activate";
    private static UtilTimerLogger logger = new UtilTimerLogger(){

        @Override
        public void log(String s) {
            log.debug(s);
        }
    };
    private final ThreadLocal<ProfilingTimerBean> current = new ThreadLocal();
    private boolean profileMemoryFlag = "true".equalsIgnoreCase(System.getProperty("atlassian.profile.activate.memory", "false"));
    private long configuredMinTime;
    private long configuredMinTotalTime;
    private int configuredMaxFrameCount = Integer.getInteger("atlassian.profile.maxframecount", 1500);
    private boolean enabled;

    public StackProfilingStrategy() {
        this.configuredMinTime = Long.getLong(MIN_TIME, 0L);
        this.configuredMinTotalTime = Long.getLong(MIN_TOTAL_TIME, 0L);
        this.enabled = "true".equalsIgnoreCase(System.getProperty(ACTIVATE_PROPERTY, "false"));
    }

    @Override
    public void start(String name) {
        ProfilingTimerBean currentTimer;
        if (!this.isEnabled()) {
            return;
        }
        ProfilingTimerBean newTimer = new ProfilingTimerBean(name);
        newTimer.setStartTime();
        if (this.isProfileMemory()) {
            newTimer.setStartMem();
        }
        if ((currentTimer = this.current.get()) != null) {
            currentTimer.addChild(newTimer);
            newTimer.setFrameCount(currentTimer.getFrameCount() + 1);
        }
        this.current.set(newTimer);
    }

    @Override
    public void stop(String name) {
        ProfilingTimerBean currentTimer = this.current.get();
        if (currentTimer == null) {
            return;
        }
        currentTimer.setEndMem();
        if (name != null && name.equals(currentTimer.getResource())) {
            currentTimer.setEndTime();
            ProfilingTimerBean parent = currentTimer.getParent();
            if (parent == null) {
                if (currentTimer.getTotalTime() > this.getMinTotalTime()) {
                    this.printTimes(currentTimer);
                }
                this.current.remove();
            } else {
                if (currentTimer.getTotalTime() < this.getMinTime() || currentTimer.getFrameCount() > this.getMaxFrameCount()) {
                    parent.removeChild(currentTimer);
                }
                parent.setFrameCount(currentTimer.getFrameCount());
                this.current.set(parent);
            }
        } else {
            this.printTimes(currentTimer);
            this.current.remove();
            log.debug("Unmatched Timer.  Was expecting {}, instead got {}", (Object)currentTimer.getResource(), (Object)name);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isProfileMemory() {
        return this.profileMemoryFlag;
    }

    public long getMinTime() {
        return this.configuredMinTime;
    }

    public int getMaxFrameCount() {
        return this.configuredMaxFrameCount;
    }

    public long getMinTotalTime() {
        return this.configuredMinTotalTime;
    }

    public void setProfileMemoryFlag(boolean profileMemoryFlag) {
        this.profileMemoryFlag = profileMemoryFlag;
    }

    public void setConfiguredMinTime(long configuredMinTime) {
        this.configuredMinTime = configuredMinTime;
    }

    public void setConfiguredMaxFrameCount(int configuredMaxFrameCount) {
        this.configuredMaxFrameCount = configuredMaxFrameCount;
    }

    public void setConfiguredMinTotalTime(long configuredMinTotalTime) {
        this.configuredMinTotalTime = configuredMinTotalTime;
    }

    private void printTimes(ProfilingTimerBean currentTimer) {
        String printable = currentTimer.getPrintable(this.getMinTime());
        if (printable != null && !"".equals(printable.trim())) {
            logger.log(printable);
        }
    }

    public UtilTimerLogger getLogger() {
        return logger;
    }

    public void setLogger(UtilTimerLogger logger) {
        StackProfilingStrategy.logger = logger;
    }
}

