/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.spi.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public final class OsgiServiceProxy {
    private static final int SERVICE_WAIT_SECONDS = 20;

    public static <T> T wrapService(BundleContext consumingBundleContext, Class<T> interfaceClass, ClassLoader consumerClassLoader) {
        return interfaceClass.cast(Proxy.newProxyInstance(consumerClassLoader, new Class[]{interfaceClass}, new ServiceTrackerInvocationHandler<T>(consumingBundleContext, interfaceClass)));
    }

    private static final class ServiceTrackerInvocationHandler<T>
    implements InvocationHandler {
        private final ServiceTracker serviceTracker;
        private final Class<T> interfaceClass;

        public ServiceTrackerInvocationHandler(BundleContext consumingBundleContext, Class<T> interfaceClass) {
            this.interfaceClass = interfaceClass;
            this.serviceTracker = new ServiceTracker(consumingBundleContext, interfaceClass.getName(), null);
            this.serviceTracker.open();
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            try {
                T instance = this.interfaceClass.cast(this.serviceTracker.waitForService(TimeUnit.SECONDS.toMillis(20L)));
                if (instance == null) {
                    throw new IllegalStateException("Service not available within 20 seconds: '" + this.interfaceClass.getName() + "'");
                }
                return method.invoke(instance, objects);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        protected void finalize() throws Throwable {
            this.serviceTracker.close();
            super.finalize();
        }
    }
}

