/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.spi.permission;

import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.spi.permission.Permission;
import com.atlassian.plugin.remotable.spi.permission.PermissionInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public abstract class AbstractPermission
implements Permission {
    public static final Set<InstallationMode> DEFAULT_INSTALLATION_MODES = ImmutableSet.of((Object)InstallationMode.LOCAL);
    private final String key;
    private final ImmutableSet<InstallationMode> installationModes;
    private final PermissionInfo permissionInfo;

    protected AbstractPermission(String key) {
        this(key, (Set<InstallationMode>)ImmutableSet.of((Object)InstallationMode.LOCAL));
    }

    protected AbstractPermission(String key, Set<InstallationMode> installationModes) {
        this(key, installationModes, EmptyPermissionInfo.INSTANCE);
    }

    protected AbstractPermission(String key, Set<InstallationMode> installationModes, PermissionInfo permissionInfo) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.installationModes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(installationModes)));
        this.permissionInfo = (PermissionInfo)Preconditions.checkNotNull((Object)permissionInfo);
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public final Set<InstallationMode> getInstallationModes() {
        return this.installationModes;
    }

    public final String getName() {
        return this.permissionInfo.getName();
    }

    public final String getDescription() {
        return this.permissionInfo.getDescription();
    }

    @Override
    public final PermissionInfo getPermissionInfo() {
        return this.permissionInfo;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractPermission)) {
            return false;
        }
        AbstractPermission that = (AbstractPermission)o;
        return this.key.equals(that.key);
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    private static enum EmptyPermissionInfo implements PermissionInfo
    {
        INSTANCE;


        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getDescription() {
            return "";
        }
    }
}

