/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.sisu;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAnnotatedMethodTypeListener
implements TypeListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String JAVA_PACKAGE = "java";
    private final Class<? extends Annotation> annotationType;

    public <A extends Annotation> AbstractAnnotatedMethodTypeListener(Class<A> annotationType) {
        this.annotationType = (Class)Preconditions.checkNotNull(annotationType);
    }

    @Override
    public final <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        this.hear(type.getRawType(), encounter);
    }

    private <I> void hear(Class<? super I> type, TypeEncounter<I> encounter) {
        this.logger.debug("Encountering type: {}", type);
        if (type == null || this.isProxy(type) || this.isJdkType(type)) {
            return;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(this.annotationType)) continue;
            if (method.getParameterTypes().length != 0) {
                encounter.addError("Annotated methods with @%s must not accept any argument, found %s", this.annotationType.getName(), method);
            }
            this.hear(method, encounter);
        }
        this.hear(type.getSuperclass(), encounter);
    }

    @VisibleForTesting
    boolean isProxy(final Class<?> type) {
        return (Boolean)Option.option(type).map(new Function<Class<?>, String>(){

            public String apply(Class<?> type) {
                return type.getSimpleName();
            }
        }).fold(Suppliers.alwaysFalse(), (Function)new Function<String, Boolean>(){

            public Boolean apply(String typeSimpleName) {
                boolean isProxy = typeSimpleName.startsWith("$Proxy");
                AbstractAnnotatedMethodTypeListener.this.logger.debug("Type '{}' is {} a proxy", (Object)type, (Object)(isProxy ? "" : "NOT"));
                return isProxy;
            }
        });
    }

    @VisibleForTesting
    boolean isJdkType(Class<?> type) {
        return (Boolean)Option.option(type).map(new Function<Class<?>, Package>(){

            public Package apply(Class<?> type) {
                return type.getPackage();
            }
        }).map((Function)new Function<Package, String>(){

            public String apply(Package typePackage) {
                return typePackage.getName();
            }
        }).fold(Suppliers.alwaysFalse(), (Function)new Function<String, Boolean>(){

            public Boolean apply(String packageName) {
                return packageName.startsWith(AbstractAnnotatedMethodTypeListener.JAVA_PACKAGE);
            }
        });
    }

    protected final Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    protected abstract <I> void hear(Method var1, TypeEncounter<I> var2);
}

