/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.util.function;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class MapFunctions {
    public static final Function<Object, String> OBJECT_TO_STRING = new Function<Object, String>(){

        public String apply(Object from) {
            return from != null ? from.toString() : null;
        }
    };
    public static final Function<String[], String> STRING_ARRAY_TO_STRING = new Function<String[], String>(){

        public String apply(String[] from) {
            return from != null && from.length > 0 ? from[0] : null;
        }
    };
    public static final Function<String, List<String>> STRING_TO_LIST = new Function<String, List<String>>(){

        public List<String> apply(@Nullable String s) {
            return Collections.singletonList(s);
        }
    };

    private MapFunctions() {
    }
}

