/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.jira;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.webfragment.conditions.BrowseUsersPermissionCondition;
import com.atlassian.jira.plugin.webfragment.conditions.CanAttachFileToIssueCondition;
import com.atlassian.jira.plugin.webfragment.conditions.CanAttachScreenshotToIssueCondition;
import com.atlassian.jira.plugin.webfragment.conditions.CanConvertToIssueCondition;
import com.atlassian.jira.plugin.webfragment.conditions.CanConvertToSubTaskCondition;
import com.atlassian.jira.plugin.webfragment.conditions.CanCreateSharedObjectsCondition;
import com.atlassian.jira.plugin.webfragment.conditions.CanManageAttachmentsCondition;
import com.atlassian.jira.plugin.webfragment.conditions.ExternalUserManagementDisabledCondition;
import com.atlassian.jira.plugin.webfragment.conditions.HasIssuePermissionCondition;
import com.atlassian.jira.plugin.webfragment.conditions.HasLastSearchRequestCondition;
import com.atlassian.jira.plugin.webfragment.conditions.HasLinkTypesAvailableCondition;
import com.atlassian.jira.plugin.webfragment.conditions.HasProjectPermissionCondition;
import com.atlassian.jira.plugin.webfragment.conditions.HasSelectedProjectCondition;
import com.atlassian.jira.plugin.webfragment.conditions.HasSubTasksAvailableCondition;
import com.atlassian.jira.plugin.webfragment.conditions.HasVotedForIssueCondition;
import com.atlassian.jira.plugin.webfragment.conditions.IsAdminModeCondition;
import com.atlassian.jira.plugin.webfragment.conditions.IsFieldHiddenCondition;
import com.atlassian.jira.plugin.webfragment.conditions.IsIssueAssignedToCurrentUserCondition;
import com.atlassian.jira.plugin.webfragment.conditions.IsIssueEditableCondition;
import com.atlassian.jira.plugin.webfragment.conditions.IsIssueReportedByCurrentUserCondition;
import com.atlassian.jira.plugin.webfragment.conditions.IsIssueUnresolvedCondition;
import com.atlassian.jira.plugin.webfragment.conditions.IsKeyboardShortcutsEnabledCondition;
import com.atlassian.jira.plugin.webfragment.conditions.IsSubTaskCondition;
import com.atlassian.jira.plugin.webfragment.conditions.IsWatchingIssueCondition;
import com.atlassian.jira.plugin.webfragment.conditions.LinkingEnabledCondition;
import com.atlassian.jira.plugin.webfragment.conditions.NotVersionContextCondition;
import com.atlassian.jira.plugin.webfragment.conditions.SmtpMailServerConfiguredCondition;
import com.atlassian.jira.plugin.webfragment.conditions.SubTasksEnabledCondition;
import com.atlassian.jira.plugin.webfragment.conditions.TimeTrackingEnabledCondition;
import com.atlassian.jira.plugin.webfragment.conditions.UserHasIssueHistoryCondition;
import com.atlassian.jira.plugin.webfragment.conditions.UserIsAdminCondition;
import com.atlassian.jira.plugin.webfragment.conditions.UserIsProjectAdminCondition;
import com.atlassian.jira.plugin.webfragment.conditions.UserIsSysAdminCondition;
import com.atlassian.jira.plugin.webfragment.conditions.UserIsTheLoggedInUserCondition;
import com.atlassian.jira.plugin.webfragment.conditions.UserLoggedInCondition;
import com.atlassian.jira.plugin.webfragment.conditions.VotingEnabledCondition;
import com.atlassian.jira.plugin.webfragment.conditions.WatchingEnabledCondition;
import com.atlassian.jira.plugin.webfragment.descriptors.JiraWebItemModuleDescriptor;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.plugin.remotable.spi.product.ProductAccessor;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public final class JiraProductAccessor
implements ProductAccessor {
    private final UserManager userManager;
    private final MailQueue mailQueue;

    public JiraProductAccessor(UserManager userManager, MailQueue mailQueue) {
        this.userManager = userManager;
        this.mailQueue = mailQueue;
    }

    @Override
    public WebItemModuleDescriptor createWebItemModuleDescriptor() {
        return new JiraWebItemModuleDescriptor(ComponentManager.getInstance().getJiraAuthenticationContext(), (WebInterfaceManager)ComponentManager.getComponent(WebInterfaceManager.class));
    }

    @Override
    public String getPreferredAdminSectionKey() {
        return "advanced_menu_section/advanced_section";
    }

    @Override
    public int getPreferredAdminWeight() {
        return 150;
    }

    @Override
    public String getKey() {
        return "jira";
    }

    @Override
    public int getPreferredGeneralWeight() {
        return 100;
    }

    @Override
    public String getPreferredGeneralSectionKey() {
        return "system.top.navigation.bar";
    }

    @Override
    public int getPreferredProfileWeight() {
        return 100;
    }

    @Override
    public String getPreferredProfileSectionKey() {
        return "system.user.options/personal";
    }

    @Override
    public Map<String, String> getLinkContextParams() {
        return ImmutableMap.of((Object)"project_id", (Object)"$!helper.project.id", (Object)"project_key", (Object)"$!helper.project.key", (Object)"issue_id", (Object)"$!issue.id", (Object)"issue_key", (Object)"$!issue.key");
    }

    @Override
    public void sendEmail(String userName, Email email, String bodyAsHtml, String bodyAsText) {
        User user = this.userManager.getUser(userName);
        JiraUserPreferences userPrefs = new JiraUserPreferences(user);
        String prefFormat = userPrefs.getString("user.notifications.mimetype");
        if (!"html".equalsIgnoreCase(prefFormat)) {
            email.setMimeType("text/html");
            email.setBody(bodyAsHtml);
        } else {
            email.setMimeType("text/plain");
            email.setBody(bodyAsText);
        }
        this.mailQueue.addItem((MailQueueItem)new SingleMailQueueItem(email));
    }

    @Override
    public void flushEmail() {
        this.mailQueue.sendBuffer();
    }

    @Override
    public Map<String, Class<? extends Condition>> getConditions() {
        HashMap conditions = Maps.newHashMap();
        conditions.put("has_selected_project", HasSelectedProjectCondition.class);
        conditions.put("sub_tasks_enabled", SubTasksEnabledCondition.class);
        conditions.put("linking_enabled", LinkingEnabledCondition.class);
        conditions.put("smtp_mail_server_configured", SmtpMailServerConfiguredCondition.class);
        conditions.put("external_user_management_disabled", ExternalUserManagementDisabledCondition.class);
        conditions.put("time_tracking_enabled", TimeTrackingEnabledCondition.class);
        conditions.put("user_has_issue_history", UserHasIssueHistoryCondition.class);
        conditions.put("user_is_project_admin", UserIsProjectAdminCondition.class);
        conditions.put("is_field_hidden", IsFieldHiddenCondition.class);
        conditions.put("browse_users_permission", BrowseUsersPermissionCondition.class);
        conditions.put("voting_enabled", VotingEnabledCondition.class);
        conditions.put("user_is_the_logged_in_user", UserIsTheLoggedInUserCondition.class);
        conditions.put("has_last_search_request", HasLastSearchRequestCondition.class);
        conditions.put("not_version_context", NotVersionContextCondition.class);
        conditions.put("user_is_sysadmin", UserIsSysAdminCondition.class);
        conditions.put("has_link_types_available", HasLinkTypesAvailableCondition.class);
        conditions.put("can_create_shared_objects", CanCreateSharedObjectsCondition.class);
        conditions.put("user_is_logged_in", UserLoggedInCondition.class);
        conditions.put("watching_enabled", WatchingEnabledCondition.class);
        conditions.put("is_keyboard_shortcuts_enabled", IsKeyboardShortcutsEnabledCondition.class);
        conditions.put("user_is_admin", UserIsAdminCondition.class);
        conditions.put("is_admin_mode", IsAdminModeCondition.class);
        conditions.put("can_convert_to_issue", CanConvertToIssueCondition.class);
        conditions.put("is_issue_reported_by_current_user", IsIssueReportedByCurrentUserCondition.class);
        conditions.put("is_sub_task", IsSubTaskCondition.class);
        conditions.put("can_manage_attachments", CanManageAttachmentsCondition.class);
        conditions.put("is_issue_editable", IsIssueEditableCondition.class);
        conditions.put("is_issue_unresolved", IsIssueUnresolvedCondition.class);
        conditions.put("can_attach_file_to_issue", CanAttachFileToIssueCondition.class);
        conditions.put("has_voted_for_issue", HasVotedForIssueCondition.class);
        conditions.put("can_attach_screenshot_to_issue", CanAttachScreenshotToIssueCondition.class);
        conditions.put("is_issue_assigned_to_current_user", IsIssueAssignedToCurrentUserCondition.class);
        conditions.put("is_watching_issue", IsWatchingIssueCondition.class);
        conditions.put("has_sub_tasks_available", HasSubTasksAvailableCondition.class);
        conditions.put("can_convert_to_sub_task", CanConvertToSubTaskCondition.class);
        conditions.put("has_issue_permission", HasIssuePermissionCondition.class);
        conditions.put("has_project_permission", HasProjectPermissionCondition.class);
        return conditions;
    }
}

