/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.jira.issuetab;

import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel2;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsReply;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelReply;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.plugin.remotable.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.remotable.plugin.module.jira.JiraTabConditionContext;
import com.atlassian.plugin.remotable.spi.module.IFrameContext;
import com.atlassian.plugin.remotable.spi.module.IFrameRenderer;
import com.atlassian.plugin.web.Condition;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IFrameIssueTabPage
extends AbstractIssueTabPanel2 {
    private static final Logger log = LoggerFactory.getLogger(IFrameIssueTabPage.class);
    private final IFrameRendererImpl iFrameRenderer;
    private final Optional<Condition> condition;
    private final IFrameContext iFrameContext;

    public IFrameIssueTabPage(IFrameContext iFrameContext, IFrameRendererImpl iFrameRenderer, Optional<Condition> condition) {
        this.iFrameContext = (IFrameContext)Preconditions.checkNotNull((Object)iFrameContext);
        this.iFrameRenderer = (IFrameRendererImpl)Preconditions.checkNotNull((Object)iFrameRenderer);
        this.condition = condition;
    }

    public GetActionsReply getActions(GetActionsRequest request) {
        return GetActionsReply.create((IssueAction[])new IssueAction[]{new IFrameIssueAction(request, this.iFrameRenderer, this.iFrameContext)});
    }

    public ShowPanelReply showPanel(ShowPanelRequest request) {
        return ShowPanelReply.create((!this.condition.isPresent() || ((Condition)this.condition.get()).shouldDisplay(JiraTabConditionContext.createConditionContext(request)) ? 1 : 0) != 0);
    }

    public static class IFrameIssueAction
    implements IssueAction {
        private final GetActionsRequest request;
        private final IFrameRenderer iFrameRenderer;
        private final IFrameContext iFrameContext;

        public IFrameIssueAction(GetActionsRequest request, IFrameRenderer iFrameRenderer, IFrameContext iFrameContext) {
            this.request = request;
            this.iFrameRenderer = iFrameRenderer;
            this.iFrameContext = iFrameContext;
        }

        public String getHtml() {
            StringWriter writer = new StringWriter();
            try {
                ImmutableMap extraParams = ImmutableMap.of((Object)"ctx_issue_key", (Object)new String[]{this.request.issue().getKey()});
                String remoteUserName = this.getRemoteUserName();
                writer.write(this.iFrameRenderer.render(this.iFrameContext, "", (Map<String, String[]>)extraParams, remoteUserName));
            }
            catch (IOException e) {
                log.error("Error rendering tab", (Throwable)e);
                throw new RuntimeException(e);
            }
            return writer.toString();
        }

        private String getRemoteUserName() {
            return this.request.remoteUser() != null ? this.request.remoteUser().getName() : null;
        }

        public Date getTimePerformed() {
            throw new UnsupportedOperationException();
        }

        public boolean isDisplayActionAllTab() {
            return false;
        }
    }
}

