/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.sisu;

import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAnnotatedClassTypeListener<A extends Annotation>
implements TypeListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<A> annotationType;

    protected AbstractAnnotatedClassTypeListener(Class<A> annotationType) {
        this.annotationType = (Class)Preconditions.checkNotNull(annotationType);
    }

    @Override
    public final <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        Class<I> clazz = type.getRawType();
        if (clazz.isAnnotationPresent(this.annotationType)) {
            this.hear(type, encounter, clazz.getAnnotation(this.annotationType));
        }
    }

    protected abstract <I> void hear(TypeLiteral<I> var1, TypeEncounter<I> var2, A var3);
}

