/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.permission;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import com.atlassian.plugin.remotable.spi.permission.AbstractPermission;
import com.atlassian.plugin.remotable.spi.permission.DefaultPermission;
import com.atlassian.plugin.remotable.spi.permission.Permission;
import com.atlassian.plugin.remotable.spi.permission.PermissionInfo;
import com.atlassian.plugin.remotable.spi.permission.PermissionModuleDescriptor;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiScope;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPermissionModuleDescriptor
extends AbstractModuleDescriptor<Permission>
implements PermissionModuleDescriptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Supplier<? extends Permission> permissionSupplier;

    public DefaultPermissionModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        this.checkHasDefinePluginPermissionPermission(plugin);
        super.init(plugin, element);
        final Set<InstallationMode> installationModes = this.getInstallationModes(element);
        final PermissionInfo permissionInfo = this.getPermissionInfo();
        this.permissionSupplier = Suppliers.memoize((Supplier)new Supplier<Permission>(){

            public Permission get() {
                Permission permissionFromModuleClassName;
                Permission permission = DefaultPermissionModuleDescriptor.this.moduleClassName == null ? new DefaultPermission(DefaultPermissionModuleDescriptor.this.getKey(), installationModes.isEmpty() ? AbstractPermission.DEFAULT_INSTALLATION_MODES : installationModes, permissionInfo) : ((permissionFromModuleClassName = DefaultPermissionModuleDescriptor.this.getPermissionFromModuleClassName()) instanceof ApiScope ? new ForwardingApiScope((ApiScope)permissionFromModuleClassName, permissionInfo) : new ForwardingPermission(permissionFromModuleClassName, permissionInfo, null));
                return permission;
            }
        });
    }

    private Permission getPermissionFromModuleClassName() {
        return (Permission)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    private void checkHasDefinePluginPermissionPermission(Plugin plugin) {
        boolean hasAllPermissions;
        try {
            hasAllPermissions = plugin.hasAllPermissions();
        }
        catch (NoSuchMethodError error) {
            this.logger.debug("We're using Atlassian Plugins 2, plugins have all permissions, will allow {}", (Object)"define_plugin_permission", (Object)error);
            hasAllPermissions = true;
        }
        if (hasAllPermissions) {
            return;
        }
        if (!plugin.getActivePermissions().contains("define_plugin_permission")) {
            throw new PermissionDeniedException(plugin.getKey(), String.format("Could not define permission, as plugin doesn't have the required '%s' permission", "define_plugin_permission"));
        }
    }

    private PermissionInfo getPermissionInfo() {
        return new DefaultPermissionInfo(this.getName(), this.getDescription());
    }

    private Set<InstallationMode> getInstallationModes(Element element) {
        List elements = element.elements("installation-mode");
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)elements, (Function)new Function<Element, Option<InstallationMode>>(){

            public Option<InstallationMode> apply(Element e) {
                return InstallationMode.of(e.getText());
            }
        }), (Predicate)new Predicate<Option<InstallationMode>>(){

            public boolean apply(Option<InstallationMode> mode) {
                return mode.isDefined();
            }
        }), (Function)new Function<Option<InstallationMode>, InstallationMode>(){

            public InstallationMode apply(Option<InstallationMode> option) {
                return (InstallationMode)((Object)option.get());
            }
        }));
    }

    public Permission getModule() {
        return (Permission)this.permissionSupplier.get();
    }

    private static final class ForwardingApiScope
    extends ForwardingPermission<ApiScope>
    implements ApiScope {
        private ForwardingApiScope(ApiScope delegate, PermissionInfo permissionInfo) {
            super(delegate, permissionInfo, null);
        }

        @Override
        public boolean allow(HttpServletRequest request, String user) {
            return ((ApiScope)this.delegate).allow(request, user);
        }

        @Override
        public Iterable<ApiResourceInfo> getApiResourceInfos() {
            return ((ApiScope)this.delegate).getApiResourceInfos();
        }
    }

    private static class ForwardingPermission<P extends Permission>
    implements Permission {
        protected final P delegate;
        private final PermissionInfo permissionInfo;

        private ForwardingPermission(P delegate, PermissionInfo permissionInfo) {
            this.delegate = (Permission)Preconditions.checkNotNull(delegate);
            this.permissionInfo = (PermissionInfo)Preconditions.checkNotNull((Object)permissionInfo);
        }

        @Override
        public String getKey() {
            return this.delegate.getKey();
        }

        @Override
        public PermissionInfo getPermissionInfo() {
            return this.permissionInfo;
        }

        @Override
        public Set<InstallationMode> getInstallationModes() {
            return this.delegate.getInstallationModes();
        }

        public String getName() {
            return this.permissionInfo.getName();
        }

        public String getDescription() {
            return this.permissionInfo.getDescription();
        }

        /* synthetic */ ForwardingPermission(Permission x0, PermissionInfo x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static final class DefaultPermissionInfo
    implements PermissionInfo {
        private final String name;
        private final String description;

        private DefaultPermissionInfo(String name, String description) {
            this.name = name;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

