/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.descriptor;

import com.google.common.base.Preconditions;
import org.dom4j.Document;
import org.dom4j.Element;

public final class DescriptorUtils {
    private DescriptorUtils() {
    }

    public static String getDisplayUrl(Document descriptor) {
        return DescriptorUtils.getDisplayUrl(descriptor.getRootElement());
    }

    public static String getOAuthPublicKey(Document descriptor) {
        Element root = descriptor.getRootElement();
        String value = DescriptorUtils.isAtlassianPluginDescriptor(descriptor.getRootElement()) ? DescriptorUtils.getOAuthPublicKey(DescriptorUtils.getRemotePluginContainerElement(root)) : DescriptorUtils.getOAuthPublicKey(root);
        return value;
    }

    private static String getDisplayUrl(Element root) {
        Preconditions.checkState((boolean)root.isRootElement());
        return DescriptorUtils.getDisplayUrlAttribute(DescriptorUtils.getRemotePluginContainerElement(root));
    }

    private static String getDisplayUrlAttribute(Element element) {
        return element.attributeValue("display-url");
    }

    public static Element getRemotePluginContainerElement(Element root) {
        Preconditions.checkState((boolean)root.isRootElement());
        return DescriptorUtils.element(root, "remote-plugin-container");
    }

    public static Document addDisplayUrl(Element element, String displayUrl) {
        return element.addAttribute("display-url", displayUrl).getDocument();
    }

    public static Document addRegistrationWebHook(Element root) {
        for (Element webHook : root.elements("webhook")) {
            if (!"remote_plugin_installed".equals(webHook.attributeValue("event"))) continue;
            return root.getDocument();
        }
        root.addElement("webhook").addAttribute("event", "remote_plugin_installed").addAttribute("url", "/").addAttribute("key", "_registration");
        return root.getDocument();
    }

    private static String getOAuthPublicKey(Element element) {
        return DescriptorUtils.text(DescriptorUtils.element(element, "oauth", false), "public-key", false);
    }

    private static boolean isAtlassianPluginDescriptor(Element root) {
        Preconditions.checkState((boolean)root.isRootElement());
        return root.getName().equals("atlassian-plugin") && root.attribute("plugins-version") != null;
    }

    private static Element element(Element parent, String name) {
        return DescriptorUtils.element(parent, name, true);
    }

    private static Element element(Element parent, String name, boolean required) {
        Element child;
        Element element = child = parent != null ? parent.element(name) : null;
        if (required && child == null) {
            String pname = parent != null ? parent.getName() : null;
            throw new IllegalStateException("Required element '" + name + "' to be present on '" + pname + "' element");
        }
        return child;
    }

    private static String text(Element parent, String name, boolean required) {
        Element target = DescriptorUtils.element(parent, name, required);
        return target != null ? DescriptorUtils.removeSpacesOnEnds(target.getText()) : null;
    }

    private static String removeSpacesOnEnds(String text) {
        StringBuilder sb = new StringBuilder();
        for (String line : text.split("\n|\r\n|\r")) {
            sb.append(line.trim()).append("\n");
        }
        return sb.toString();
    }
}

